/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.1.2")
public final class DtoInstantiatingConverter
implements Converter<EntityInstanceWithSource, Object> {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(DtoInstantiatingConverter.class));
    private final Class<?> targetType;
    private final Neo4jMappingContext context;

    public DtoInstantiatingConverter(Class<?> dtoType, Neo4jMappingContext context) {
        Assert.notNull(dtoType, (String)"DTO type must not be null!");
        Assert.notNull((Object)context, (String)"MappingContext must not be null!");
        this.targetType = dtoType;
        this.context = context;
    }

    public Object convertDirectly(Object entityInstance) {
        Neo4jPersistentEntity sourceEntity = (Neo4jPersistentEntity)this.context.getRequiredPersistentEntity(entityInstance.getClass());
        PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(entityInstance);
        Neo4jPersistentEntity targetEntity = this.context.addPersistentEntity((TypeInformation<?>)ClassTypeInformation.from(this.targetType)).orElse(null);
        Assert.notNull((Object)targetEntity, (String)"Target entity could not be created for a DTO");
        PreferredConstructor constructor = targetEntity.getPersistenceConstructor();
        Object dto = this.context.getInstantiatorFor((PersistentEntity<?, ?>)targetEntity).createInstance((PersistentEntity)targetEntity, this.getParameterValueProvider(targetEntity, targetProperty -> this.getPropertyValueDirectlyFor((PersistentProperty<?>)targetProperty, (PersistentEntity<?, ?>)sourceEntity, (PersistentPropertyAccessor<?>)sourceAccessor)));
        PersistentPropertyAccessor dtoAccessor = targetEntity.getPropertyAccessor(dto);
        targetEntity.doWithProperties(property -> {
            if (constructor != null && constructor.isConstructorParameter(property)) {
                return;
            }
            Object propertyValue = this.getPropertyValueDirectlyFor((PersistentProperty<?>)property, (PersistentEntity<?, ?>)sourceEntity, (PersistentPropertyAccessor<?>)sourceAccessor);
            dtoAccessor.setProperty(property, propertyValue);
        });
        return dto;
    }

    @Nullable
    Object getPropertyValueDirectlyFor(PersistentProperty<?> targetProperty, PersistentEntity<?, ?> sourceEntity, PersistentPropertyAccessor<?> sourceAccessor) {
        String targetPropertyName = targetProperty.getName();
        PersistentProperty sourceProperty = sourceEntity.getPersistentProperty(targetPropertyName);
        if (sourceProperty == null) {
            return null;
        }
        return sourceAccessor.getProperty(sourceProperty);
    }

    public Object convert(@Nullable EntityInstanceWithSource entityInstanceAndSource) {
        if (entityInstanceAndSource == null) {
            return null;
        }
        Object entityInstance = entityInstanceAndSource.getEntityInstance();
        if (this.targetType.isInterface() || this.targetType.isInstance(entityInstance)) {
            return entityInstance;
        }
        Neo4jPersistentEntity sourceEntity = (Neo4jPersistentEntity)this.context.getRequiredPersistentEntity(entityInstance.getClass());
        PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(entityInstance);
        Neo4jPersistentEntity<?> targetEntity = this.context.addPersistentEntity((TypeInformation<?>)ClassTypeInformation.from(this.targetType)).orElseThrow(() -> new MappingException("Could not add a persistent entity for the projection target type '" + this.targetType.getName() + "'."));
        PreferredConstructor constructor = targetEntity.getPersistenceConstructor();
        Object dto = this.context.getInstantiatorFor((PersistentEntity<?, ?>)targetEntity).createInstance(targetEntity, this.getParameterValueProvider(targetEntity, targetProperty -> this.getPropertyValueFor((Neo4jPersistentProperty)targetProperty, (PersistentEntity<?, ?>)sourceEntity, (PersistentPropertyAccessor<?>)sourceAccessor, entityInstanceAndSource)));
        PersistentPropertyAccessor dtoAccessor = targetEntity.getPropertyAccessor(dto);
        targetEntity.doWithAll(property -> this.setPropertyOnDtoObject(entityInstanceAndSource, (PersistentEntity<?, ?>)sourceEntity, (PersistentPropertyAccessor<Object>)sourceAccessor, (PreferredConstructor<?, ?>)constructor, (PersistentPropertyAccessor<Object>)dtoAccessor, (Neo4jPersistentProperty)property));
        return dto;
    }

    private ParameterValueProvider<Neo4jPersistentProperty> getParameterValueProvider(final Neo4jPersistentEntity<?> targetEntity, final Function<Neo4jPersistentProperty, Object> extractFromSource) {
        return new ParameterValueProvider<Neo4jPersistentProperty>(){

            public <T> T getParameterValue(PreferredConstructor.Parameter<T, Neo4jPersistentProperty> parameter) {
                String parameterName = parameter.getName();
                if (parameterName == null) {
                    throw new MappingException("Constructor parameter names aren't available, please recompile your domain.");
                }
                Neo4jPersistentProperty targetProperty = (Neo4jPersistentProperty)targetEntity.getPersistentProperty(parameterName);
                if (targetProperty == null) {
                    throw new MappingException("Cannot map constructor parameter " + parameterName + " to a property of class " + DtoInstantiatingConverter.this.targetType);
                }
                return (T)extractFromSource.apply(targetProperty);
            }
        };
    }

    private void setPropertyOnDtoObject(EntityInstanceWithSource entityInstanceAndSource, PersistentEntity<?, ?> sourceEntity, PersistentPropertyAccessor<Object> sourceAccessor, @Nullable PreferredConstructor<?, ?> constructor, PersistentPropertyAccessor<Object> dtoAccessor, Neo4jPersistentProperty property) {
        if (constructor != null && constructor.isConstructorParameter((PersistentProperty)property)) {
            return;
        }
        Object propertyValue = this.getPropertyValueFor(property, sourceEntity, sourceAccessor, entityInstanceAndSource);
        dtoAccessor.setProperty((PersistentProperty)property, propertyValue);
    }

    @Nullable
    Object getPropertyValueFor(Neo4jPersistentProperty targetProperty, PersistentEntity<?, ?> sourceEntity, PersistentPropertyAccessor<?> sourceAccessor, EntityInstanceWithSource entityInstanceAndSource) {
        TypeSystem typeSystem = entityInstanceAndSource.getTypeSystem();
        MapAccessor sourceRecord = entityInstanceAndSource.getSourceRecord();
        String targetPropertyName = targetProperty.getName();
        PersistentProperty sourceProperty = sourceEntity.getPersistentProperty(targetPropertyName);
        if (sourceProperty != null) {
            return sourceAccessor.getProperty(sourceProperty);
        }
        if (!sourceRecord.containsKey(targetPropertyName)) {
            log.warn(() -> String.format("Cannot retrieve a value for property `%s` of DTO `%s` and the property will always be null. Make sure to project only properties of the domain type or use a custom query that returns a mappable data under the name `%1$s`.", targetPropertyName, this.targetType.getName()));
        } else if (targetProperty.isMap()) {
            log.warn(() -> String.format("%s is an additional property to be projected. However, map properties cannot be projected and the property will always be null.", targetPropertyName));
        } else {
            Value property = sourceRecord.get(targetPropertyName);
            if (targetProperty.isCollectionLike() && !typeSystem.LIST().isTypeOf(property)) {
                log.warn(() -> String.format("%s is a list property but the selected value is not a list and the property will always be null.", targetPropertyName));
            } else {
                Function<Value, Object> singleValue;
                Class actualType = targetProperty.getActualType();
                if (this.context.hasPersistentEntityFor(actualType)) {
                    singleValue = p -> this.context.getEntityConverter().read(actualType, p);
                } else {
                    ClassTypeInformation actualTargetType = ClassTypeInformation.from((Class)actualType);
                    singleValue = p -> this.context.getConversionService().readValue((Value)p, (TypeInformation<?>)actualTargetType, targetProperty.getOptionalConverter());
                }
                if (targetProperty.isCollectionLike()) {
                    List returnedValues = property.asList(singleValue);
                    Collection target = CollectionFactory.createCollection((Class)targetProperty.getType(), (Class)actualType, (int)returnedValues.size());
                    target.addAll(returnedValues);
                    return target;
                }
                return singleValue.apply(property);
            }
        }
        return null;
    }
}

