/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.support.CypherdslStatementExecutor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class Neo4jQueryMethod
extends QueryMethod {
    @Nullable
    private final Query queryAnnotation;
    private final String repositoryName;
    private final boolean cypherBasedProjection;

    Neo4jQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        this(method, metadata, factory, ClassUtils.hasMethod(CypherdslStatementExecutor.class, (Method)method));
    }

    Neo4jQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, boolean cypherBasedProjection) {
        super(method, metadata, factory);
        Class<?> declaringClass = method.getDeclaringClass();
        this.repositoryName = declaringClass.getName();
        this.cypherBasedProjection = cypherBasedProjection;
        this.queryAnnotation = (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class);
    }

    String getRepositoryName() {
        return this.repositoryName;
    }

    boolean isCollectionLikeQuery() {
        return this.isCollectionQuery() || this.isStreamQuery();
    }

    boolean isCypherBasedProjection() {
        return this.cypherBasedProjection;
    }

    boolean hasQueryAnnotation() {
        return this.queryAnnotation != null;
    }

    Optional<Query> getQueryAnnotation() {
        return Optional.ofNullable(this.queryAnnotation);
    }

    protected Parameters<Neo4jParameters, Neo4jParameter> createParameters(Method method) {
        return new Neo4jParameters(method);
    }

    static class Neo4jParameters
    extends Parameters<Neo4jParameters, Neo4jParameter> {
        Neo4jParameters(Method method) {
            super(method);
        }

        private Neo4jParameters(List<Neo4jParameter> originals) {
            super(originals);
        }

        protected Neo4jParameter createParameter(MethodParameter parameter) {
            return new Neo4jParameter(parameter);
        }

        protected Neo4jParameters createFrom(List<Neo4jParameter> parameters) {
            return new Neo4jParameters(parameters);
        }
    }

    static class Neo4jParameter
    extends Parameter {
        private static final String NAMED_PARAMETER_TEMPLATE = "$%s";
        private static final String POSITION_PARAMETER_TEMPLATE = "$%d";

        Neo4jParameter(MethodParameter parameter) {
            super(parameter);
        }

        public String getPlaceholder() {
            if (this.isNamedParameter()) {
                return String.format(NAMED_PARAMETER_TEMPLATE, this.getName().get());
            }
            return String.format(POSITION_PARAMETER_TEMPLATE, this.getIndex());
        }

        public String getNameOrIndex() {
            return this.getName().orElseGet(() -> Integer.toString(this.getIndex()));
        }
    }
}

