/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.neo4j.config.Neo4jEntityScanner;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;

@API(status=API.Status.STABLE, since="6.0")
abstract class Neo4jConfigurationSupport {
    Neo4jConfigurationSupport() {
    }

    @Bean
    Neo4jConversions neo4jConversions() {
        return new Neo4jConversions();
    }

    @Bean
    Configuration cypherDslConfiguration() {
        return Configuration.defaultConfig();
    }

    @Bean
    Neo4jMappingContext neo4jMappingContext(Neo4jConversions neo4JConversions) throws ClassNotFoundException {
        Neo4jMappingContext mappingContext = new Neo4jMappingContext(neo4JConversions);
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        return mappingContext;
    }

    protected Collection<String> getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        return mappingBasePackage != null ? List.of(mappingBasePackage.getName()) : List.of();
    }

    protected final Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        return Neo4jEntityScanner.get().scan(this.getMappingBasePackages());
    }
}

