/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;

@API(status=API.Status.INTERNAL, since="6.1.2")
public final class EntityInstanceWithSource {
    private final Object entityInstance;
    private final TypeSystem typeSystem;
    private final MapAccessor sourceRecord;

    private EntityInstanceWithSource(Object entityInstance, TypeSystem typeSystem, MapAccessor sourceRecord) {
        this.entityInstance = entityInstance;
        this.typeSystem = typeSystem;
        this.sourceRecord = sourceRecord;
    }

    public static BiFunction<TypeSystem, MapAccessor, ?> decorateMappingFunction(BiFunction<TypeSystem, MapAccessor, ?> target) {
        return (t, r) -> new EntityInstanceWithSource(target.apply((TypeSystem)t, (MapAccessor)r), (TypeSystem)t, (MapAccessor)r);
    }

    public Object getEntityInstance() {
        return this.entityInstance;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public MapAccessor getSourceRecord() {
        return this.sourceRecord;
    }
}

