/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Vector;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.schema.CompositeProperty;
import org.springframework.data.neo4j.core.schema.DynamicLabels;

@API(status=API.Status.STABLE, since="6.0")
public interface Neo4jPersistentProperty
extends PersistentProperty<Neo4jPersistentProperty>,
GraphPropertyDescription {
    default public boolean isDynamicAssociation() {
        Class componentType = this.getComponentType();
        return this.isRelationship() && this.isMap() && (componentType == String.class || componentType != null && componentType.isEnum());
    }

    default public boolean isDynamicOneToManyAssociation() {
        return this.isDynamicAssociation() && this.getTypeInformation().getRequiredActualType().isCollectionLike();
    }

    default public boolean isDynamicLabels() {
        return this.isAnnotationPresent(DynamicLabels.class) && this.isCollectionLike();
    }

    default public boolean isVectorProperty() {
        return this.getType().isAssignableFrom(Vector.class);
    }

    public @Nullable Neo4jPersistentPropertyConverter<?> getOptionalConverter();

    public boolean isEntityWithRelationshipProperties();

    default public String computePrefixWithDelimiter() {
        CompositeProperty compositeProperty = (CompositeProperty)this.getRequiredAnnotation(CompositeProperty.class);
        return Optional.of(compositeProperty.prefix()).map(String::trim).filter(s -> !s.isEmpty()).orElseGet(this::getFieldName) + compositeProperty.delimiter();
    }

    default public boolean isReadOnly() {
        return false;
    }
}

