/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.neo4j.core.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.UnknownEntityException;
import org.springframework.data.neo4j.core.schema.IdGenerator;

@API(status=API.Status.INTERNAL, since="6.0")
public interface Schema {
    public @Nullable NodeDescription<?> getNodeDescription(String var1);

    public @Nullable NodeDescription<?> getNodeDescription(Class<?> var1);

    default public NodeDescription<?> getRequiredNodeDescription(Class<?> underlyingClass) {
        NodeDescription<?> nodeDescription = this.getNodeDescription(underlyingClass);
        if (nodeDescription == null) {
            throw new UnknownEntityException(underlyingClass);
        }
        return nodeDescription;
    }

    default public NodeDescription<?> getRequiredNodeDescription(String primaryLabel) {
        NodeDescription<?> nodeDescription = this.getNodeDescription(primaryLabel);
        if (nodeDescription == null) {
            throw new MappingException(String.format("Required node description not found with primary label '%s'", primaryLabel));
        }
        return nodeDescription;
    }

    default public <T> BiFunction<TypeSystem, MapAccessor, T> getRequiredMappingFunctionFor(Class<T> targetClass) {
        NodeDescription<?> nodeDescription = this.getNodeDescription(targetClass);
        if (nodeDescription == null) {
            throw new UnknownEntityException(targetClass);
        }
        Neo4jEntityConverter entityConverter = this.getEntityConverter();
        return (typeSystem, record) -> {
            try {
                return entityConverter.read(targetClass, record);
            }
            catch (IllegalStateException ex) {
                return null;
            }
        };
    }

    public Neo4jEntityConverter getEntityConverter();

    default public <T> Function<T, Map<String, Object>> getRequiredBinderFunctionFor(Class<T> sourceClass) {
        if (this.getNodeDescription(sourceClass) == null) {
            throw new UnknownEntityException(sourceClass);
        }
        Neo4jEntityConverter entityConverter = this.getEntityConverter();
        return t -> {
            HashMap parameters = new HashMap();
            entityConverter.write(t, parameters);
            return parameters;
        };
    }

    public <T extends IdGenerator<?>> T getOrCreateIdGeneratorOfType(Class<T> var1);

    public <T extends IdGenerator<?>> Optional<T> getIdGenerator(String var1);
}

