/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.config;

import io.r2dbc.spi.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.MappingR2dbcConverter;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.DefaultReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.dialect.DialectResolver;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.R2dbcMappingContext;
import org.springframework.data.r2dbc.support.R2dbcExceptionSubclassTranslator;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
public abstract class AbstractR2dbcConfiguration
implements ApplicationContextAware {
    private static final String CONNECTION_FACTORY_BEAN_NAME = "connectionFactory";
    @Nullable
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public abstract ConnectionFactory connectionFactory();

    public R2dbcDialect getDialect(ConnectionFactory connectionFactory) {
        return DialectResolver.getDialect(connectionFactory);
    }

    @Bean
    public DatabaseClient databaseClient(ReactiveDataAccessStrategy dataAccessStrategy, R2dbcExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null!");
        Assert.notNull((Object)exceptionTranslator, (String)"ExceptionTranslator must not be null!");
        return DatabaseClient.builder().connectionFactory(this.lookupConnectionFactory()).dataAccessStrategy(dataAccessStrategy).exceptionTranslator(exceptionTranslator).build();
    }

    @Bean
    public RelationalMappingContext r2dbcMappingContext(Optional<NamingStrategy> namingStrategy, R2dbcCustomConversions r2dbcCustomConversions) {
        Assert.notNull(namingStrategy, (String)"NamingStrategy must not be null!");
        R2dbcMappingContext relationalMappingContext = new R2dbcMappingContext(namingStrategy.orElse(NamingStrategy.INSTANCE));
        relationalMappingContext.setSimpleTypeHolder(r2dbcCustomConversions.getSimpleTypeHolder());
        return relationalMappingContext;
    }

    @Bean
    public ReactiveDataAccessStrategy reactiveDataAccessStrategy(RelationalMappingContext mappingContext, R2dbcCustomConversions r2dbcCustomConversions) {
        Assert.notNull((Object)mappingContext, (String)"MappingContext must not be null!");
        MappingR2dbcConverter converter = new MappingR2dbcConverter((MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)mappingContext, r2dbcCustomConversions);
        return new DefaultReactiveDataAccessStrategy(this.getDialect(this.lookupConnectionFactory()), converter);
    }

    @Bean
    public R2dbcCustomConversions r2dbcCustomConversions() {
        return new R2dbcCustomConversions(this.getStoreConversions(), this.getCustomConverters());
    }

    protected List<Object> getCustomConverters() {
        return Collections.emptyList();
    }

    protected CustomConversions.StoreConversions getStoreConversions() {
        R2dbcDialect dialect = this.getDialect(this.lookupConnectionFactory());
        ArrayList<Object> converters = new ArrayList<Object>(dialect.getConverters());
        converters.addAll(R2dbcCustomConversions.STORE_CONVERTERS);
        return CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), converters);
    }

    @Bean
    public R2dbcExceptionTranslator exceptionTranslator() {
        return new R2dbcExceptionSubclassTranslator();
    }

    ConnectionFactory lookupConnectionFactory() {
        String[] beanNamesForType;
        ApplicationContext context = this.context;
        Assert.notNull((Object)context, (String)"ApplicationContext is not yet initialized");
        for (String beanName : beanNamesForType = context.getBeanNamesForType(ConnectionFactory.class)) {
            if (!beanName.equals(CONNECTION_FACTORY_BEAN_NAME)) continue;
            return (ConnectionFactory)context.getBean(CONNECTION_FACTORY_BEAN_NAME, ConnectionFactory.class);
        }
        return this.connectionFactory();
    }
}

