/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.util.Lazy;
import org.springframework.util.ClassUtils;

public class PostgresDialect
extends org.springframework.data.relational.core.dialect.PostgresDialect
implements R2dbcDialect {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(UUID.class, URL.class, URI.class, InetAddress.class));
    public static final PostgresDialect INSTANCE = new PostgresDialect();
    private static final BindMarkersFactory INDEXED = BindMarkersFactory.indexed("$", 1);
    private final Lazy<ArrayColumns> arrayColumns = Lazy.of(() -> new R2dbcArrayColumns(org.springframework.data.relational.core.dialect.PostgresDialect.INSTANCE.getArraySupport(), this.getSimpleTypeHolder()));

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return INDEXED;
    }

    @Override
    public Collection<? extends Class<?>> getSimpleTypes() {
        return SIMPLE_TYPES;
    }

    public ArrayColumns getArraySupport() {
        return (ArrayColumns)this.arrayColumns.get();
    }

    private static class R2dbcArrayColumns
    implements ArrayColumns {
        private final ArrayColumns delegate;
        private final SimpleTypeHolder simpleTypeHolder;

        R2dbcArrayColumns(ArrayColumns delegate, SimpleTypeHolder simpleTypeHolder) {
            this.delegate = delegate;
            this.simpleTypeHolder = simpleTypeHolder;
        }

        public boolean isSupported() {
            return this.delegate.isSupported();
        }

        public Class<?> getArrayType(Class<?> userType) {
            Class<?> typeToUse = userType;
            while (typeToUse.getComponentType() != null) {
                typeToUse = typeToUse.getComponentType();
            }
            if (!this.simpleTypeHolder.isSimpleType(typeToUse)) {
                throw new IllegalArgumentException("Unsupported array type: " + ClassUtils.getQualifiedName(typeToUse));
            }
            return this.delegate.getArrayType(typeToUse);
        }
    }
}

