/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.FetchSpec;
import org.springframework.data.r2dbc.repository.query.BindableQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcParameterAccessor;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryExecution;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractR2dbcQuery
implements RepositoryQuery {
    private final R2dbcQueryMethod method;
    private final DatabaseClient databaseClient;
    private final R2dbcConverter converter;
    private final EntityInstantiators instantiators;

    public AbstractR2dbcQuery(R2dbcQueryMethod method, DatabaseClient databaseClient, R2dbcConverter converter) {
        Assert.notNull((Object)((Object)method), (String)"R2dbcQueryMethod must not be null!");
        Assert.notNull((Object)databaseClient, (String)"DatabaseClient must not be null!");
        Assert.notNull((Object)converter, (String)"R2dbcConverter must not be null!");
        this.method = method;
        this.databaseClient = databaseClient;
        this.converter = converter;
        this.instantiators = new EntityInstantiators();
    }

    public R2dbcQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        return this.method.hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.execute((RelationalParameterAccessor)new RelationalParametersParameterAccessor((QueryMethod)this.method, parameters));
    }

    private Object executeDeferred(Object[] parameters) {
        R2dbcParameterAccessor parameterAccessor = new R2dbcParameterAccessor(this.method, parameters);
        if (this.getQueryMethod().isCollectionQuery()) {
            return Flux.defer(() -> (Publisher)this.execute((RelationalParameterAccessor)parameterAccessor));
        }
        return Mono.defer(() -> (Mono)this.execute((RelationalParameterAccessor)parameterAccessor));
    }

    private Object execute(RelationalParameterAccessor parameterAccessor) {
        BindableQuery query = this.createQuery(parameterAccessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        DatabaseClient.GenericExecuteSpec boundQuery = query.bind(this.databaseClient.execute(query));
        FetchSpec<?> fetchSpec = boundQuery.as(this.resolveResultType(processor)).fetch();
        SqlIdentifier tableName = this.method.getEntityInformation().getTableName();
        R2dbcQueryExecution.ResultProcessingExecution execution = new R2dbcQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(processor.getReturnedType()), new R2dbcQueryExecution.ResultProcessingConverter(processor, this.converter.getMappingContext(), this.instantiators));
        return execution.execute(fetchSpec, processor.getReturnedType().getDomainType(), tableName);
    }

    private Class<?> resolveResultType(ResultProcessor resultProcessor) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        return returnedType.isProjecting() ? returnedType.getDomainType() : returnedType.getReturnedType();
    }

    private R2dbcQueryExecution getExecutionToWrap(ReturnedType returnedType) {
        if (this.isModifyingQuery()) {
            if (Boolean.class.isAssignableFrom(returnedType.getReturnedType())) {
                return (q, t, c) -> q.rowsUpdated().map(integer -> integer > 0);
            }
            if (Number.class.isAssignableFrom(returnedType.getReturnedType())) {
                return (q, t, c) -> q.rowsUpdated().map(integer -> this.converter.getConversionService().convert(integer, returnedType.getReturnedType()));
            }
            if (Void.class.isAssignableFrom(returnedType.getReturnedType())) {
                return (q, t, c) -> q.rowsUpdated().then();
            }
            return (q, t, c) -> q.rowsUpdated();
        }
        if (this.method.isCollectionQuery()) {
            return (q, t, c) -> q.all();
        }
        return (q, t, c) -> q.one();
    }

    protected abstract boolean isModifyingQuery();

    protected abstract BindableQuery createQuery(RelationalParameterAccessor var1);
}

