/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.mapping.event;

import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.r2dbc.mapping.event.BeforeConvertCallback;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;

public class ReactiveAuditingEntityCallback
implements BeforeConvertCallback<Object>,
Ordered {
    private final ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory;

    public ReactiveAuditingEntityCallback(ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public Publisher<Object> onBeforeConvert(Object entity, SqlIdentifier table) {
        return ((ReactiveIsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity);
    }

    public int getOrder() {
        return 100;
    }
}

