/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jredis;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jredis.ClientRuntimeException;
import org.jredis.JRedis;
import org.jredis.Query;
import org.jredis.RedisException;
import org.jredis.Sort;
import org.jredis.protocol.Command;
import org.jredis.ri.alphazero.JRedisService;
import org.jredis.ri.alphazero.JRedisSupport;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.jredis.JredisUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JredisConnection
implements RedisConnection {
    private static final Method SERVICE_REQUEST = ReflectionUtils.findMethod(JRedisSupport.class, (String)"serviceRequest", (Class[])new Class[]{Command.class, byte[][].class});
    private final JRedis jredis;
    private final boolean isPool;
    private boolean isClosed = false;

    public JredisConnection(JRedis jredis) {
        Assert.notNull((Object)jredis, (String)"a not-null instance required");
        this.jredis = jredis;
        this.isPool = jredis instanceof JRedisService;
    }

    protected DataAccessException convertJredisAccessException(Exception ex) {
        if (ex instanceof RedisException) {
            return JredisUtils.convertJredisAccessException((RedisException)ex);
        }
        if (ex instanceof ClientRuntimeException) {
            return JredisUtils.convertJredisAccessException((ClientRuntimeException)ex);
        }
        return new RedisSystemException("Unknown JRedis exception", ex);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            ArrayList mArgs = new ArrayList();
            if (!ObjectUtils.isEmpty((Object[])args)) {
                Collections.addAll(mArgs, args);
            }
            return ReflectionUtils.invokeMethod((Method)SERVICE_REQUEST, (Object)this.jredis, (Object[])new Object[]{Command.valueOf((String)command.trim().toUpperCase()), mArgs.toArray((T[])new byte[mArgs.size()][])});
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void close() throws RedisSystemException {
        this.isClosed = true;
        if (!this.isPool) {
            try {
                this.jredis.quit();
            }
            catch (Exception ex) {
                throw this.convertJredisAccessException(ex);
            }
        }
    }

    public JRedis getNativeConnection() {
        return this.jredis;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isQueueing() {
        return false;
    }

    @Override
    public boolean isPipelined() {
        return false;
    }

    @Override
    public void openPipeline() {
        throw new UnsupportedOperationException("Pipelining not supported by JRedis");
    }

    @Override
    public List<Object> closePipeline() {
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        Sort sort = this.jredis.sort(JredisUtils.decode(key));
        JredisUtils.applySortingParams(sort, params, null);
        try {
            return sort.exec();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        Sort sort = this.jredis.sort(JredisUtils.decode(key));
        JredisUtils.applySortingParams(sort, params, storeKey);
        try {
            return Query.Support.unpackValue((List)sort.exec());
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            return this.jredis.dbsize();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            this.jredis.flushdb();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            this.jredis.flushall();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            return this.jredis.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            this.jredis.ping();
            return "PONG";
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            this.jredis.bgsave();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void bgWriteAof() {
        try {
            this.jredis.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            this.jredis.save();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties info() {
        try {
            return JredisUtils.info(this.jredis.info());
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            return this.jredis.lastsave();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetConfigStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            return this.jredis.del(JredisUtils.decodeMultiple(keys));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void discard() {
        try {
            this.jredis.discard();
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            return this.jredis.exists(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            return this.jredis.expire(JredisUtils.decode(key), (int)seconds);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            return this.jredis.expireat(JredisUtils.decode(key), unixTime);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            return JredisUtils.convertToSet(this.jredis.keys(JredisUtils.decode(pattern)));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void multi() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean persist(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            return this.jredis.move(JredisUtils.decode(key), dbIndex);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            return JredisUtils.encode(this.jredis.randomkey());
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            this.jredis.rename(JredisUtils.decode(oldName), JredisUtils.decode(newName));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            return this.jredis.renamenx(JredisUtils.decode(oldName), JredisUtils.decode(newName));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            return this.jredis.ttl(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            return JredisUtils.convertDataType(this.jredis.type(JredisUtils.decode(key)));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void watch(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            return this.jredis.get(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            this.jredis.set(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            return this.jredis.getset(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            return this.jredis.append(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            return this.jredis.mget(JredisUtils.decodeMultiple(keys));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuple) {
        try {
            this.jredis.mset(JredisUtils.decodeMap(tuple));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void mSetNX(Map<byte[], byte[]> tuple) {
        try {
            this.jredis.msetnx(JredisUtils.decodeMap(tuple));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long seconds, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            return this.jredis.setnx(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            return this.jredis.substr(JredisUtils.decode(key), start, end);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            return this.jredis.decr(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            return this.jredis.decrby(JredisUtils.decode(key), (int)value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            return this.jredis.incr(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            return this.jredis.incrby(JredisUtils.decode(key), (int)value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long strLen(byte[] key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            return this.jredis.lindex(JredisUtils.decode(key), index);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            return this.jredis.llen(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            return this.jredis.lpop(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] value) {
        try {
            this.jredis.lpush(JredisUtils.decode(key), value);
            return null;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            List lrange = this.jredis.lrange(JredisUtils.decode(key), start, end);
            return lrange;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            return this.jredis.lrem(JredisUtils.decode(key), value, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            this.jredis.lset(JredisUtils.decode(key), index, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            this.jredis.ltrim(JredisUtils.decode(key), start, end);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            return this.jredis.rpop(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            return this.jredis.rpoplpush(JredisUtils.decode(srcKey), JredisUtils.decode(dstKey));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] value) {
        try {
            this.jredis.rpush(JredisUtils.decode(key), value);
            return null;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean sAdd(byte[] key, byte[] value) {
        try {
            return this.jredis.sadd(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            return this.jredis.scard(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        String destKey = JredisUtils.decode(keys[0]);
        String[] sets = JredisUtils.decodeMultiple((byte[][])Arrays.copyOfRange(keys, 1, keys.length));
        try {
            List result = this.jredis.sdiff(destKey, sets);
            return new LinkedHashSet<byte[]>(result);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        String destSet = JredisUtils.decode(destKey);
        String[] sets = JredisUtils.decodeMultiple(keys);
        try {
            this.jredis.sdiffstore(destSet, sets);
            return -1L;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        String set1 = JredisUtils.decode(keys[0]);
        String[] sets = JredisUtils.decodeMultiple((byte[][])Arrays.copyOfRange(keys, 1, keys.length));
        try {
            List result = this.jredis.sinter(set1, sets);
            return new LinkedHashSet<byte[]>(result);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        String destSet = JredisUtils.decode(destKey);
        String[] sets = JredisUtils.decodeMultiple(keys);
        try {
            this.jredis.sinterstore(destSet, sets);
            return -1L;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            return this.jredis.sismember(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.smembers(JredisUtils.decode(key)));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            return this.jredis.smove(JredisUtils.decode(srcKey), JredisUtils.decode(destKey), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            return this.jredis.spop(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            return this.jredis.srandmember(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean sRem(byte[] key, byte[] value) {
        try {
            return this.jredis.srem(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        String set1 = JredisUtils.decode(keys[0]);
        String[] sets = JredisUtils.decodeMultiple((byte[][])Arrays.copyOfRange(keys, 1, keys.length));
        try {
            return new LinkedHashSet<byte[]>(this.jredis.sunion(set1, sets));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        String destSet = JredisUtils.decode(destKey);
        String[] sets = JredisUtils.decodeMultiple(keys);
        try {
            this.jredis.sunionstore(destSet, sets);
            return -1L;
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            return this.jredis.zadd(JredisUtils.decode(key), score, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            return this.jredis.zcard(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            return this.jredis.zcount(JredisUtils.decode(key), min, max);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            return this.jredis.zincrby(JredisUtils.decode(key), increment, value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.zrange(JredisUtils.decode(key), start, end));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.zrangebyscore(JredisUtils.decode(key), min, max));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            return this.jredis.zrank(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean zRem(byte[] key, byte[] value) {
        try {
            return this.jredis.zrem(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            return this.jredis.zremrangebyrank(JredisUtils.decode(key), start, end);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            return this.jredis.zremrangebyscore(JredisUtils.decode(key), min, max);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            return new LinkedHashSet<byte[]>(this.jredis.zrevrange(JredisUtils.decode(key), start, end));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            return this.jredis.zrevrank(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            return this.jredis.zscore(JredisUtils.decode(key), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean hDel(byte[] key, byte[] field) {
        try {
            return this.jredis.hdel(JredisUtils.decode(key), JredisUtils.decode(field));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            return this.jredis.hexists(JredisUtils.decode(key), JredisUtils.decode(field));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            return this.jredis.hget(JredisUtils.decode(key), JredisUtils.decode(field));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            return JredisUtils.encodeMap(this.jredis.hgetall(JredisUtils.decode(key)));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            return new LinkedHashSet<byte[]>(JredisUtils.convertToSet(this.jredis.hkeys(JredisUtils.decode(key))));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            return this.jredis.hlen(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            return this.jredis.hset(JredisUtils.decode(key), JredisUtils.decode(field), value);
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            return this.jredis.hvals(JredisUtils.decode(key));
        }
        catch (Exception ex) {
            throw this.convertJredisAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return null;
    }

    @Override
    public boolean isSubscribed() {
        return false;
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        throw new UnsupportedOperationException();
    }

    static {
        ReflectionUtils.makeAccessible((Method)SERVICE_REQUEST);
    }
}

