/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.script.ScriptExecutor;
import org.springframework.data.redis.serializer.RedisSerializer;

public class DefaultScriptExecutor<K>
implements ScriptExecutor<K> {
    private RedisTemplate<K, ?> template;

    public DefaultScriptExecutor(RedisTemplate<K, ?> template) {
        this.template = template;
    }

    @Override
    public <T> T execute(RedisScript<T> script, List<K> keys, Object ... args) {
        return this.execute(script, this.template.getValueSerializer(), this.template.getValueSerializer(), keys, args);
    }

    @Override
    public <T> T execute(final RedisScript<T> script, final RedisSerializer<?> argsSerializer, final RedisSerializer<T> resultSerializer, final List<K> keys, final Object ... args) {
        return this.template.execute(new RedisCallback<T>(){

            @Override
            public T doInRedis(RedisConnection connection) throws DataAccessException {
                int keySize;
                ReturnType returnType = ReturnType.fromJavaType(script.getResultType());
                byte[][] keysAndArgs = DefaultScriptExecutor.this.keysAndArgs(argsSerializer, keys, args);
                int n = keySize = keys != null ? keys.size() : 0;
                if (connection.isPipelined() || connection.isQueueing()) {
                    connection.eval(DefaultScriptExecutor.this.scriptBytes(script), returnType, keySize, keysAndArgs);
                    return null;
                }
                return DefaultScriptExecutor.this.eval(connection, script, returnType, keySize, keysAndArgs, resultSerializer);
            }
        });
    }

    protected <T> T eval(RedisConnection connection, RedisScript<T> script, ReturnType returnType, int numKeys, byte[][] keysAndArgs, RedisSerializer<T> resultSerializer) {
        Object result;
        try {
            result = connection.evalSha(script.getSha1(), returnType, numKeys, keysAndArgs);
        }
        catch (Exception e) {
            if (!this.exceptionContainsNoScriptError(e)) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RedisSystemException(e.getMessage(), e);
            }
            result = connection.eval(this.scriptBytes(script), returnType, numKeys, keysAndArgs);
        }
        if (script.getResultType() == null) {
            return null;
        }
        return this.deserializeResult(resultSerializer, result);
    }

    protected byte[][] keysAndArgs(RedisSerializer argsSerializer, List<K> keys, Object[] args) {
        int keySize = keys != null ? keys.size() : 0;
        byte[][] keysAndArgs = new byte[args.length + keySize][];
        int i = 0;
        if (keys != null) {
            for (Object key : keys) {
                if (this.keySerializer() == null && key instanceof byte[]) {
                    keysAndArgs[i++] = (byte[])key;
                    continue;
                }
                keysAndArgs[i++] = this.keySerializer().serialize(key);
            }
        }
        for (Object arg : args) {
            keysAndArgs[i++] = argsSerializer == null && arg instanceof byte[] ? (byte[])arg : argsSerializer.serialize(arg);
        }
        return keysAndArgs;
    }

    protected byte[] scriptBytes(RedisScript<?> script) {
        return this.template.getStringSerializer().serialize(script.getScriptAsString());
    }

    protected <T> T deserializeResult(RedisSerializer<T> resultSerializer, Object result) {
        if (result instanceof byte[]) {
            if (resultSerializer == null) {
                return (T)result;
            }
            return resultSerializer.deserialize((byte[])result);
        }
        if (result instanceof List) {
            ArrayList<T> results = new ArrayList<T>();
            for (Object obj : (List)result) {
                results.add(this.deserializeResult(resultSerializer, obj));
            }
            return (T)results;
        }
        return (T)result;
    }

    protected RedisSerializer keySerializer() {
        return this.template.getKeySerializer();
    }

    private boolean exceptionContainsNoScriptError(Exception e) {
        if (!(e instanceof NonTransientDataAccessException)) {
            return false;
        }
        for (Throwable current = e; current != null; current = current.getCause()) {
            String exMessage = current.getMessage();
            if (exMessage == null || !exMessage.contains("NOSCRIPT")) continue;
            return true;
        }
        return false;
    }
}

