/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

class DefaultRedisElementReader<T>
implements RedisElementReader<T> {
    @Nullable
    private final RedisSerializer<T> serializer;

    @Override
    public T read(ByteBuffer buffer) {
        if (this.serializer == null) {
            return (T)buffer;
        }
        byte[] bytes = new byte[buffer.slice().remaining()];
        buffer.get(bytes);
        return this.serializer.deserialize(bytes);
    }

    @ConstructorProperties(value={"serializer"})
    public DefaultRedisElementReader(@Nullable RedisSerializer<T> serializer) {
        this.serializer = serializer;
    }
}

