/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Set;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;

public interface ZSetOperations<K, V> {
    @Nullable
    public Boolean add(K var1, V var2, double var3);

    @Nullable
    public Long add(K var1, Set<TypedTuple<V>> var2);

    @Nullable
    public Long remove(K var1, Object ... var2);

    @Nullable
    public Double incrementScore(K var1, V var2, double var3);

    @Nullable
    public Long rank(K var1, Object var2);

    @Nullable
    public Long reverseRank(K var1, Object var2);

    @Nullable
    public Set<V> range(K var1, long var2, long var4);

    @Nullable
    public Set<TypedTuple<V>> rangeWithScores(K var1, long var2, long var4);

    @Nullable
    public Set<V> rangeByScore(K var1, double var2, double var4);

    @Nullable
    public Set<TypedTuple<V>> rangeByScoreWithScores(K var1, double var2, double var4);

    @Nullable
    public Set<V> rangeByScore(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Set<TypedTuple<V>> rangeByScoreWithScores(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Set<V> reverseRange(K var1, long var2, long var4);

    @Nullable
    public Set<TypedTuple<V>> reverseRangeWithScores(K var1, long var2, long var4);

    @Nullable
    public Set<V> reverseRangeByScore(K var1, double var2, double var4);

    @Nullable
    public Set<TypedTuple<V>> reverseRangeByScoreWithScores(K var1, double var2, double var4);

    @Nullable
    public Set<V> reverseRangeByScore(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Set<TypedTuple<V>> reverseRangeByScoreWithScores(K var1, double var2, double var4, long var6, long var8);

    @Nullable
    public Long count(K var1, double var2, double var4);

    @Nullable
    public Long size(K var1);

    @Nullable
    public Long zCard(K var1);

    @Nullable
    public Double score(K var1, Object var2);

    @Nullable
    public Long removeRange(K var1, long var2, long var4);

    @Nullable
    public Long removeRangeByScore(K var1, double var2, double var4);

    @Nullable
    public Long unionAndStore(K var1, K var2, K var3);

    @Nullable
    public Long unionAndStore(K var1, Collection<K> var2, K var3);

    @Nullable
    default public Long unionAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Nullable
    public Long unionAndStore(K var1, Collection<K> var2, K var3, RedisZSetCommands.Aggregate var4, RedisZSetCommands.Weights var5);

    @Nullable
    public Long intersectAndStore(K var1, K var2, K var3);

    @Nullable
    public Long intersectAndStore(K var1, Collection<K> var2, K var3);

    @Nullable
    default public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Nullable
    public Long intersectAndStore(K var1, Collection<K> var2, K var3, RedisZSetCommands.Aggregate var4, RedisZSetCommands.Weights var5);

    public Cursor<TypedTuple<V>> scan(K var1, ScanOptions var2);

    @Nullable
    public Set<V> rangeByLex(K var1, RedisZSetCommands.Range var2);

    @Nullable
    public Set<V> rangeByLex(K var1, RedisZSetCommands.Range var2, RedisZSetCommands.Limit var3);

    public RedisOperations<K, V> getOperations();

    public static interface TypedTuple<V>
    extends Comparable<TypedTuple<V>> {
        @Nullable
        public V getValue();

        @Nullable
        public Double getScore();
    }
}

