/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.convert.GeoIndexedPropertyValue;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.SimpleIndexedPropertyValue;
import org.springframework.data.redis.core.index.GeoIndexDefinition;
import org.springframework.data.redis.core.index.IndexDefinition;
import org.springframework.data.redis.core.index.SimpleIndexDefinition;
import org.springframework.lang.Nullable;

class IndexedDataFactoryProvider {
    IndexedDataFactoryProvider() {
    }

    @Nullable
    IndexedDataFactory getIndexedDataFactory(IndexDefinition definition) {
        if (definition instanceof SimpleIndexDefinition) {
            return new SimpleIndexedPropertyValueFactory((SimpleIndexDefinition)definition);
        }
        if (definition instanceof GeoIndexDefinition) {
            return new GeoIndexedPropertyValueFactory((GeoIndexDefinition)definition);
        }
        return null;
    }

    static class GeoIndexedPropertyValueFactory
    implements IndexedDataFactory {
        final GeoIndexDefinition indexDefinition;

        @Override
        public GeoIndexedPropertyValue createIndexedDataFor(Object value) {
            return new GeoIndexedPropertyValue(this.indexDefinition.getKeyspace(), this.indexDefinition.getPath(), (Point)this.indexDefinition.valueTransformer().convert(value));
        }

        public GeoIndexedPropertyValueFactory(GeoIndexDefinition indexDefinition) {
            this.indexDefinition = indexDefinition;
        }
    }

    static class SimpleIndexedPropertyValueFactory
    implements IndexedDataFactory {
        final SimpleIndexDefinition indexDefinition;

        @Override
        public SimpleIndexedPropertyValue createIndexedDataFor(Object value) {
            return new SimpleIndexedPropertyValue(this.indexDefinition.getKeyspace(), this.indexDefinition.getIndexName(), this.indexDefinition.valueTransformer().convert(value));
        }

        public SimpleIndexedPropertyValueFactory(SimpleIndexDefinition indexDefinition) {
            this.indexDefinition = indexDefinition;
        }
    }

    static interface IndexedDataFactory {
        public IndexedData createIndexedDataFor(Object var1);
    }
}

