/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.ByteBuffer;
import org.springframework.data.redis.serializer.DefaultRedisElementReader;
import org.springframework.data.redis.serializer.DefaultRedisElementWriter;
import org.springframework.data.redis.serializer.DefaultSerializationPair;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class RedisSerializerToSerializationPairAdapter<T>
implements RedisSerializationContext.SerializationPair<T> {
    private static final RedisSerializerToSerializationPairAdapter<?> BYTE_BUFFER = new RedisSerializerToSerializationPairAdapter(null);
    private static final RedisSerializerToSerializationPairAdapter<byte[]> BYTE_ARRAY = new RedisSerializerToSerializationPairAdapter<byte[]>(RedisSerializer.byteArray());
    private final DefaultSerializationPair pair;

    RedisSerializerToSerializationPairAdapter(@Nullable RedisSerializer<T> serializer) {
        this.pair = new DefaultSerializationPair<T>(new DefaultRedisElementReader<T>(serializer), new DefaultRedisElementWriter<T>(serializer));
    }

    @Deprecated
    static <T> RedisSerializationContext.SerializationPair<T> raw() {
        return RedisSerializerToSerializationPairAdapter.byteBuffer();
    }

    static RedisSerializationContext.SerializationPair<byte[]> byteArray() {
        return BYTE_ARRAY;
    }

    static RedisSerializationContext.SerializationPair<ByteBuffer> byteBuffer() {
        return BYTE_BUFFER;
    }

    public static <T> RedisSerializationContext.SerializationPair<T> from(RedisSerializer<T> redisSerializer) {
        Assert.notNull(redisSerializer, (String)"RedisSerializer must not be null!");
        return new RedisSerializerToSerializationPairAdapter<T>(redisSerializer);
    }

    @Override
    public RedisElementReader<T> getReader() {
        return this.pair.getReader();
    }

    @Override
    public RedisElementWriter<T> getWriter() {
        return this.pair.getWriter();
    }
}

