/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.stream;

import java.time.Duration;
import java.util.OptionalInt;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.hash.ObjectHashMapper;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.stream.DefaultStreamReceiver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public interface StreamReceiver<K, V extends Record<K, ?>> {
    public static StreamReceiver<String, MapRecord<String, String, String>> create(ReactiveRedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ReactiveRedisConnectionFactory must not be null!");
        RedisSerializationContext.SerializationPair<String> serializationPair = RedisSerializationContext.SerializationPair.fromSerializer(StringRedisSerializer.UTF_8);
        return StreamReceiver.create(connectionFactory, StreamReceiverOptions.builder().serializer(serializationPair).build());
    }

    public static <K, V extends Record<K, ?>> StreamReceiver<K, V> create(ReactiveRedisConnectionFactory connectionFactory, StreamReceiverOptions<K, V> options) {
        Assert.notNull((Object)connectionFactory, (String)"ReactiveRedisConnectionFactory must not be null!");
        Assert.notNull(options, (String)"StreamReceiverOptions must not be null!");
        return new DefaultStreamReceiver<K, V>(connectionFactory, options);
    }

    public Flux<V> receive(StreamOffset<K> var1);

    public Flux<V> receiveAutoAck(Consumer var1, StreamOffset<K> var2);

    public Flux<V> receive(Consumer var1, StreamOffset<K> var2);

    public static class StreamReceiverOptionsBuilder<K, V extends Record<K, ?>> {
        private Duration pollTimeout = Duration.ofSeconds(2L);
        @Nullable
        private Integer batchSize;
        private RedisSerializationContext.SerializationPair<K> keySerializer;
        private RedisSerializationContext.SerializationPair<Object> hashKeySerializer;
        private RedisSerializationContext.SerializationPair<Object> hashValueSerializer;
        @Nullable
        private HashMapper<V, ?, ?> hashMapper;
        @Nullable
        private Class<?> targetType;

        private StreamReceiverOptionsBuilder() {
        }

        public StreamReceiverOptionsBuilder<K, V> pollTimeout(Duration pollTimeout) {
            Assert.notNull((Object)pollTimeout, (String)"Poll timeout must not be null!");
            Assert.isTrue((!pollTimeout.isNegative() ? 1 : 0) != 0, (String)"Poll timeout must not be negative!");
            this.pollTimeout = pollTimeout;
            return this;
        }

        public StreamReceiverOptionsBuilder<K, V> batchSize(int recordsPerPoll) {
            Assert.isTrue((recordsPerPoll > 0 ? 1 : 0) != 0, (String)"Batch size must be greater zero!");
            this.batchSize = recordsPerPoll;
            return this;
        }

        public <T> StreamReceiverOptionsBuilder<T, MapRecord<T, T, T>> serializer(RedisSerializationContext.SerializationPair<T> pair) {
            Assert.notNull(pair, (String)"SerializationPair must not be null");
            this.keySerializer = pair;
            this.hashKeySerializer = pair;
            this.hashValueSerializer = pair;
            return this;
        }

        public <T> StreamReceiverOptionsBuilder<T, MapRecord<T, T, T>> serializer(RedisSerializationContext<T, ?> serializationContext) {
            Assert.notNull(serializationContext, (String)"RedisSerializationContext must not be null");
            this.keySerializer = serializationContext.getKeySerializationPair();
            this.hashKeySerializer = serializationContext.getHashKeySerializationPair();
            this.hashValueSerializer = serializationContext.getHashValueSerializationPair();
            return this;
        }

        public <NK, NV extends Record<NK, ?>> StreamReceiverOptionsBuilder<NK, NV> keySerializer(RedisSerializationContext.SerializationPair<NK> pair) {
            Assert.notNull(pair, (String)"SerializationPair must not be null");
            this.keySerializer = pair;
            return this;
        }

        public <HK, HV> StreamReceiverOptionsBuilder<K, MapRecord<K, HK, HV>> hashKeySerializer(RedisSerializationContext.SerializationPair<HK> pair) {
            Assert.notNull(pair, (String)"SerializationPair must not be null");
            this.hashKeySerializer = pair;
            return this;
        }

        public <HK, HV> StreamReceiverOptionsBuilder<K, MapRecord<K, HK, HV>> hashValueSerializer(RedisSerializationContext.SerializationPair<HV> pair) {
            Assert.notNull(pair, (String)"SerializationPair must not be null");
            this.hashValueSerializer = pair;
            return this;
        }

        public <NV> StreamReceiverOptionsBuilder<K, ObjectRecord<K, NV>> targetType(Class<NV> targetType) {
            Assert.notNull(targetType, (String)"Target type must not be null");
            this.targetType = targetType;
            if (this.hashMapper == null) {
                this.hashKeySerializer(RedisSerializationContext.SerializationPair.raw());
                this.hashValueSerializer(RedisSerializationContext.SerializationPair.raw());
                return this.objectMapper(new ObjectHashMapper());
            }
            return this;
        }

        public <NV> StreamReceiverOptionsBuilder<K, ObjectRecord<K, NV>> objectMapper(HashMapper<NV, ?, ?> hashMapper) {
            Assert.notNull(hashMapper, (String)"HashMapper must not be null");
            this.hashMapper = hashMapper;
            return this;
        }

        public StreamReceiverOptions<K, V> build() {
            return new StreamReceiverOptions(this.pollTimeout, this.batchSize, this.keySerializer, this.hashKeySerializer, this.hashValueSerializer, this.targetType, this.hashMapper);
        }
    }

    public static class StreamReceiverOptions<K, V extends Record<K, ?>> {
        private final Duration pollTimeout;
        @Nullable
        private final Integer batchSize;
        private final RedisSerializationContext.SerializationPair<K> keySerializer;
        private final RedisSerializationContext.SerializationPair<Object> hashKeySerializer;
        private final RedisSerializationContext.SerializationPair<Object> hashValueSerializer;
        @Nullable
        private final Class<Object> targetType;
        @Nullable
        private final HashMapper<Object, Object, Object> hashMapper;

        private StreamReceiverOptions(Duration pollTimeout, @Nullable Integer batchSize, RedisSerializationContext.SerializationPair<K> keySerializer, RedisSerializationContext.SerializationPair<Object> hashKeySerializer, RedisSerializationContext.SerializationPair<Object> hashValueSerializer, @Nullable Class<?> targetType, @Nullable HashMapper<V, ?, ?> hashMapper) {
            this.pollTimeout = pollTimeout;
            this.batchSize = batchSize;
            this.keySerializer = keySerializer;
            this.hashKeySerializer = hashKeySerializer;
            this.hashValueSerializer = hashValueSerializer;
            this.targetType = targetType;
            this.hashMapper = hashMapper;
        }

        public static StreamReceiverOptionsBuilder<String, MapRecord<String, String, String>> builder() {
            RedisSerializationContext.SerializationPair<String> serializer = RedisSerializationContext.SerializationPair.fromSerializer(StringRedisSerializer.UTF_8);
            return new StreamReceiverOptionsBuilder().serializer(serializer);
        }

        public static <T> StreamReceiverOptionsBuilder<String, ObjectRecord<String, T>> builder(HashMapper<T, byte[], byte[]> hashMapper) {
            RedisSerializationContext.SerializationPair<String> serializer = RedisSerializationContext.SerializationPair.fromSerializer(StringRedisSerializer.UTF_8);
            RedisSerializationContext.SerializationPair raw = RedisSerializationContext.SerializationPair.raw();
            return new StreamReceiverOptionsBuilder().keySerializer(serializer).hashKeySerializer(raw).hashValueSerializer(raw).objectMapper(hashMapper);
        }

        public Duration getPollTimeout() {
            return this.pollTimeout;
        }

        public OptionalInt getBatchSize() {
            return this.batchSize != null ? OptionalInt.of(this.batchSize) : OptionalInt.empty();
        }

        public RedisSerializationContext.SerializationPair<K> getKeySerializer() {
            return this.keySerializer;
        }

        public RedisSerializationContext.SerializationPair<Object> getHashKeySerializer() {
            return this.hashKeySerializer;
        }

        public RedisSerializationContext.SerializationPair<Object> getHashValueSerializer() {
            return this.hashValueSerializer;
        }

        @Nullable
        public HashMapper<Object, Object, Object> getHashMapper() {
            return this.hashMapper;
        }

        public Class<Object> getTargetType() {
            if (this.targetType != null) {
                return this.targetType;
            }
            return Object.class;
        }
    }
}

