/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.IOException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.core.Cursor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConvertingCursor<S, T>
implements Cursor<T> {
    private Cursor<S> delegate;
    private Converter<S, T> converter;

    public ConvertingCursor(Cursor<S> cursor, Converter<S, T> converter) {
        Assert.notNull(cursor, (String)"Cursor delegate must not be 'null'.");
        Assert.notNull(cursor, (String)"Converter must not be 'null'.");
        this.delegate = cursor;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    @Nullable
    public T next() {
        return (T)this.converter.convert(this.delegate.next());
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public long getCursorId() {
        return this.delegate.getCursorId();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public Cursor<T> open() {
        this.delegate = this.delegate.open();
        return this;
    }

    @Override
    public long getPosition() {
        return this.delegate.getPosition();
    }
}

