/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.params.GeoRadiusParam;

class JedisGeoCommands
implements RedisGeoCommands {
    private final JedisConnection connection;

    JedisGeoCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)point, (String)"Point must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        return this.connection.invoke().just(BinaryJedis::geoadd, PipelineBase::geoadd, key, point.getX(), point.getY(), member);
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (byte[] mapKey : memberCoordinateMap.keySet()) {
            redisGeoCoordinateMap.put(mapKey, JedisConverters.toGeoCoordinate(memberCoordinateMap.get(mapKey)));
        }
        return this.connection.invoke().just(BinaryJedis::geoadd, PipelineBase::geoadd, key, redisGeoCoordinateMap);
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(locations, (String)"Locations must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            redisGeoCoordinateMap.put(location.getName(), JedisConverters.toGeoCoordinate(location.getPoint()));
        }
        return this.connection.invoke().just(BinaryJedis::geoadd, PipelineBase::geoadd, key, redisGeoCoordinateMap);
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        Converter<Double, Distance> distanceConverter = JedisConverters.distanceConverterForMetric(RedisGeoCommands.DistanceUnit.METERS);
        return this.connection.invoke().from(BinaryJedis::geodist, PipelineBase::geodist, key, member1, member2).get(distanceConverter);
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(metric);
        Converter<Double, Distance> distanceConverter = JedisConverters.distanceConverterForMetric(metric);
        return this.connection.invoke().from(BinaryJedis::geodist, PipelineBase::geodist, key, member1, member2, geoUnit).get(distanceConverter);
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        return this.connection.invoke().fromMany(BinaryJedis::geohash, PipelineBase::geohash, key, members).toList(JedisConverters::toString);
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        return this.connection.invoke().fromMany(BinaryJedis::geopos, PipelineBase::geopos, key, members).toList(JedisConverters::toPoint);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric());
        return this.connection.invoke().from(BinaryJedis::georadius, PipelineBase::georadius, key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric())).get(converter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric());
        return this.connection.invoke().from(BinaryJedis::georadius, PipelineBase::georadius, key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric()), geoRadiusParam).get(converter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric());
        return this.connection.invoke().from(BinaryJedis::georadiusByMember, PipelineBase::georadiusByMember, key, member, radius.getValue(), geoUnit).get(converter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric());
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        return this.connection.invoke().from(BinaryJedis::georadiusByMember, PipelineBase::georadiusByMember, key, member, radius.getValue(), geoUnit, geoRadiusParam).get(converter);
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.connection.zSetCommands().zRem(key, members);
    }
}

