/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.KeyValueCallback;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RedisKeyValueTemplate
extends KeyValueTemplate {
    private final RedisKeyValueAdapter adapter;

    public RedisKeyValueTemplate(RedisKeyValueAdapter adapter, RedisMappingContext mappingContext) {
        super((KeyValueAdapter)adapter, (MappingContext)mappingContext);
        this.adapter = adapter;
    }

    public RedisConverter getConverter() {
        return this.adapter.getConverter();
    }

    public RedisMappingContext getMappingContext() {
        return (RedisMappingContext)super.getMappingContext();
    }

    public <T> List<T> find(final RedisCallback<?> callback, final Class<T> type) {
        Assert.notNull(callback, (String)"Callback must not be null.");
        return (List)this.execute(new RedisKeyValueCallback<List<T>>(){

            @Override
            public List<T> doInRedis(RedisKeyValueAdapter adapter) {
                Object callbackResult = adapter.execute(callback);
                if (callbackResult == null) {
                    return Collections.emptyList();
                }
                Set ids = ClassUtils.isAssignable(Iterable.class, callbackResult.getClass()) ? (Set)callbackResult : Collections.singleton(callbackResult);
                ArrayList result = new ArrayList();
                for (Object id : ids) {
                    String idToUse = adapter.getConverter().getConversionService().canConvert(id.getClass(), String.class) ? (String)adapter.getConverter().getConversionService().convert(id, String.class) : id.toString();
                    RedisKeyValueTemplate.this.findById(idToUse, type).ifPresent(result::add);
                }
                return result;
            }
        });
    }

    public <T> T insert(Object id, T objectToInsert) {
        if (objectToInsert instanceof PartialUpdate) {
            this.doPartialUpdate((PartialUpdate)objectToInsert);
            return objectToInsert;
        }
        if (!(objectToInsert instanceof RedisData)) {
            RedisConverter converter = this.adapter.getConverter();
            RedisPersistentEntity entity = (RedisPersistentEntity)converter.getMappingContext().getRequiredPersistentEntity(objectToInsert.getClass());
            KeyValuePersistentProperty idProperty = (KeyValuePersistentProperty)entity.getRequiredIdProperty();
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(objectToInsert);
            if (propertyAccessor.getProperty((PersistentProperty)idProperty) == null) {
                propertyAccessor.setProperty((PersistentProperty)idProperty, id);
                return (T)super.insert(id, propertyAccessor.getBean());
            }
        }
        return (T)super.insert(id, objectToInsert);
    }

    public <T> T update(T objectToUpdate) {
        if (objectToUpdate instanceof PartialUpdate) {
            this.doPartialUpdate((PartialUpdate)objectToUpdate);
            return objectToUpdate;
        }
        return (T)super.update(objectToUpdate);
    }

    public <T> T update(Object id, T objectToUpdate) {
        return (T)super.update(id, objectToUpdate);
    }

    protected void doPartialUpdate(final PartialUpdate<?> update) {
        this.execute(new RedisKeyValueCallback<Void>(){

            @Override
            public Void doInRedis(RedisKeyValueAdapter adapter) {
                adapter.update(update);
                return null;
            }
        });
    }

    public static abstract class RedisKeyValueCallback<T>
    implements KeyValueCallback<T> {
        public T doInKeyValue(KeyValueAdapter adapter) {
            return this.doInRedis((RedisKeyValueAdapter)adapter);
        }

        public abstract T doInRedis(RedisKeyValueAdapter var1);
    }
}

