/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

abstract class AbstractOperations<K, V> {
    final RedisTemplate<K, V> template;

    AbstractOperations(RedisTemplate<K, V> template) {
        this.template = template;
    }

    RedisSerializer keySerializer() {
        return this.template.getKeySerializer();
    }

    RedisSerializer valueSerializer() {
        return this.template.getValueSerializer();
    }

    RedisSerializer hashKeySerializer() {
        return this.template.getHashKeySerializer();
    }

    RedisSerializer hashValueSerializer() {
        return this.template.getHashValueSerializer();
    }

    RedisSerializer stringSerializer() {
        return this.template.getStringSerializer();
    }

    @Nullable
    <T> T execute(RedisCallback<T> callback) {
        return this.template.execute(callback, true);
    }

    public RedisOperations<K, V> getOperations() {
        return this.template;
    }

    byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (this.keySerializer() == null && key instanceof byte[]) {
            return (byte[])key;
        }
        return this.keySerializer().serialize(key);
    }

    byte[] rawString(String key) {
        return this.stringSerializer().serialize(key);
    }

    byte[] rawValue(Object value) {
        if (this.valueSerializer() == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return this.valueSerializer().serialize(value);
    }

    byte[][] rawValues(Object ... values) {
        byte[][] rawValues = new byte[values.length][];
        int i = 0;
        for (Object value : values) {
            rawValues[i++] = this.rawValue(value);
        }
        return rawValues;
    }

    byte[][] rawValues(Collection<V> values) {
        Assert.notEmpty(values, (String)"Values must not be 'null' or empty.");
        Assert.noNullElements((Object[])values.toArray(), (String)"Values must not contain 'null' value.");
        byte[][] rawValues = new byte[values.size()][];
        int i = 0;
        for (V value : values) {
            rawValues[i++] = this.rawValue(value);
        }
        return rawValues;
    }

    <HK> byte[] rawHashKey(HK hashKey) {
        Assert.notNull(hashKey, (String)"non null hash key required");
        if (this.hashKeySerializer() == null && hashKey instanceof byte[]) {
            return (byte[])hashKey;
        }
        return this.hashKeySerializer().serialize(hashKey);
    }

    <HK> byte[][] rawHashKeys(HK ... hashKeys) {
        byte[][] rawHashKeys = new byte[hashKeys.length][];
        int i = 0;
        for (HK hashKey : hashKeys) {
            rawHashKeys[i++] = this.rawHashKey(hashKey);
        }
        return rawHashKeys;
    }

    <HV> byte[] rawHashValue(HV value) {
        if (this.hashValueSerializer() == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return this.hashValueSerializer().serialize(value);
    }

    byte[][] rawKeys(K key, K otherKey) {
        byte[][] rawKeys = new byte[][]{this.rawKey(key), this.rawKey(key)};
        return rawKeys;
    }

    byte[][] rawKeys(Collection<K> keys) {
        return this.rawKeys((K)null, keys);
    }

    byte[][] rawKeys(K key, Collection<K> keys) {
        byte[][] rawKeys = new byte[keys.size() + (key != null ? 1 : 0)][];
        int i = 0;
        if (key != null) {
            rawKeys[i++] = this.rawKey(key);
        }
        for (K k : keys) {
            rawKeys[i++] = this.rawKey(k);
        }
        return rawKeys;
    }

    Set<V> deserializeValues(Set<byte[]> rawValues) {
        if (this.valueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, this.valueSerializer());
    }

    @Nullable
    Set<ZSetOperations.TypedTuple<V>> deserializeTupleValues(@Nullable Set<RedisZSetCommands.Tuple> rawValues) {
        if (rawValues == null) {
            return null;
        }
        LinkedHashSet<ZSetOperations.TypedTuple<V>> set = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (RedisZSetCommands.Tuple rawValue : rawValues) {
            set.add(this.deserializeTuple(rawValue));
        }
        return set;
    }

    List<ZSetOperations.TypedTuple<V>> deserializeTupleValues(List<RedisZSetCommands.Tuple> rawValues) {
        if (rawValues == null) {
            return null;
        }
        ArrayList<ZSetOperations.TypedTuple<V>> set = new ArrayList<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (RedisZSetCommands.Tuple rawValue : rawValues) {
            set.add(this.deserializeTuple(rawValue));
        }
        return set;
    }

    @Nullable
    ZSetOperations.TypedTuple<V> deserializeTuple(@Nullable RedisZSetCommands.Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        Object value = tuple.getValue();
        if (this.valueSerializer() != null) {
            value = this.valueSerializer().deserialize(tuple.getValue());
        }
        return new DefaultTypedTuple<byte[]>((byte[])value, tuple.getScore());
    }

    Set<RedisZSetCommands.Tuple> rawTupleValues(Set<ZSetOperations.TypedTuple<V>> values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<RedisZSetCommands.Tuple> rawTuples = new LinkedHashSet<RedisZSetCommands.Tuple>(values.size());
        for (ZSetOperations.TypedTuple<V> value : values) {
            byte[] rawValue = this.valueSerializer() == null && value.getValue() instanceof byte[] ? (byte[])value.getValue() : this.valueSerializer().serialize(value.getValue());
            rawTuples.add(new DefaultTuple(rawValue, value.getScore()));
        }
        return rawTuples;
    }

    List<V> deserializeValues(List<byte[]> rawValues) {
        if (this.valueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, this.valueSerializer());
    }

    <T> Set<T> deserializeHashKeys(Set<byte[]> rawKeys) {
        if (this.hashKeySerializer() == null) {
            return rawKeys;
        }
        return SerializationUtils.deserialize(rawKeys, this.hashKeySerializer());
    }

    <T> List<T> deserializeHashKeys(List<byte[]> rawKeys) {
        if (this.hashKeySerializer() == null) {
            return rawKeys;
        }
        return SerializationUtils.deserialize(rawKeys, this.hashKeySerializer());
    }

    <T> List<T> deserializeHashValues(List<byte[]> rawValues) {
        if (this.hashValueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, this.hashValueSerializer());
    }

    <HK, HV> Map<HK, HV> deserializeHashMap(@Nullable Map<byte[], byte[]> entries) {
        if (entries == null) {
            return null;
        }
        LinkedHashMap<HK, HV> map = new LinkedHashMap<HK, HV>(entries.size());
        for (Map.Entry<byte[], byte[]> entry : entries.entrySet()) {
            map.put(this.deserializeHashKey(entry.getKey()), this.deserializeHashValue(entry.getValue()));
        }
        return map;
    }

    K deserializeKey(byte[] value) {
        if (this.keySerializer() == null) {
            return (K)value;
        }
        return (K)this.keySerializer().deserialize(value);
    }

    Set<K> deserializeKeys(Set<byte[]> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptySet();
        }
        LinkedHashSet<K> result = new LinkedHashSet<K>(keys.size());
        for (byte[] key : keys) {
            result.add(this.deserializeKey(key));
        }
        return result;
    }

    V deserializeValue(byte[] value) {
        if (this.valueSerializer() == null) {
            return (V)value;
        }
        return (V)this.valueSerializer().deserialize(value);
    }

    String deserializeString(byte[] value) {
        return (String)this.stringSerializer().deserialize(value);
    }

    <HK> HK deserializeHashKey(byte[] value) {
        if (this.hashKeySerializer() == null) {
            return (HK)value;
        }
        return (HK)this.hashKeySerializer().deserialize(value);
    }

    <HV> HV deserializeHashValue(byte[] value) {
        if (this.hashValueSerializer() == null) {
            return (HV)value;
        }
        return (HV)this.hashValueSerializer().deserialize(value);
    }

    GeoResults<RedisGeoCommands.GeoLocation<V>> deserializeGeoResults(GeoResults<RedisGeoCommands.GeoLocation<byte[]>> source) {
        if (this.valueSerializer() == null) {
            return source;
        }
        return (GeoResults)Converters.deserializingGeoResultsConverter(this.valueSerializer()).convert(source);
    }

    abstract class ValueDeserializingRedisCallback
    implements RedisCallback<V> {
        private Object key;

        public ValueDeserializingRedisCallback(Object key) {
            this.key = key;
        }

        @Override
        public final V doInRedis(RedisConnection connection) {
            byte[] result = this.inRedis(AbstractOperations.this.rawKey(this.key), connection);
            return AbstractOperations.this.deserializeValue(result);
        }

        @Nullable
        protected abstract byte[] inRedis(byte[] var1, RedisConnection var2);
    }
}

