/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.SubscriptionListener;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceMessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

public class LettuceSubscription
extends AbstractSubscription {
    private final StatefulRedisPubSubConnection<byte[], byte[]> connection;
    private final LettuceMessageListener listener;
    private final LettuceConnectionProvider connectionProvider;
    private final RedisPubSubCommands<byte[], byte[]> pubsub;
    private final RedisPubSubAsyncCommands<byte[], byte[]> pubSubAsync;

    protected LettuceSubscription(MessageListener listener, StatefulRedisPubSubConnection<byte[], byte[]> pubsubConnection, LettuceConnectionProvider connectionProvider) {
        super(listener);
        this.connection = pubsubConnection;
        this.listener = new LettuceMessageListener(listener, listener instanceof SubscriptionListener ? (SubscriptionListener)((Object)listener) : SubscriptionListener.NO_OP_SUBSCRIPTION_LISTENER);
        this.connectionProvider = connectionProvider;
        this.pubsub = this.connection.sync();
        this.pubSubAsync = this.connection.async();
        this.connection.addListener((RedisPubSubListener)this.listener);
    }

    protected StatefulRedisPubSubConnection<byte[], byte[]> getNativeConnection() {
        return this.connection;
    }

    @Override
    protected void doClose() {
        if (!this.isAlive()) {
            return;
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        if (!this.getChannels().isEmpty()) {
            futures.add(this.pubSubAsync.unsubscribe((Object[])new byte[0][]).toCompletableFuture());
        }
        if (!this.getPatterns().isEmpty()) {
            futures.add(this.pubSubAsync.punsubscribe((Object[])new byte[0][]).toCompletableFuture());
        }
        if (!futures.isEmpty()) {
            futures.add(this.pubSubAsync.ping().toCompletableFuture());
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((v, t) -> this.connection.removeListener((RedisPubSubListener)this.listener));
        } else {
            this.connection.removeListener((RedisPubSubListener)this.listener);
        }
        this.connectionProvider.release((StatefulConnection<?, ?>)this.connection);
    }

    @Override
    protected void doPsubscribe(byte[] ... patterns) {
        this.pubsub.psubscribe((Object[])patterns);
    }

    @Override
    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        if (all) {
            this.pubsub.punsubscribe((Object[])new byte[0][]);
        } else {
            this.pubsub.punsubscribe((Object[])patterns);
        }
    }

    @Override
    protected void doSubscribe(byte[] ... channels) {
        this.pubsub.subscribe((Object[])channels);
    }

    @Override
    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        if (all) {
            this.pubsub.unsubscribe((Object[])new byte[0][]);
        } else {
            this.pubsub.unsubscribe((Object[])channels);
        }
    }
}

