/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceHyperLogLogCommands;
import org.springframework.data.redis.util.ByteUtils;

class LettuceClusterHyperLogLogCommands
extends LettuceHyperLogLogCommands {
    LettuceClusterHyperLogLogCommands(LettuceClusterConnection connection) {
        super(connection);
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.pfCount(keys);
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfcount in cluster mode");
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        byte[][] allKeys = ByteUtils.mergeArrays(destinationKey, sourceKeys);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            super.pfMerge(destinationKey, sourceKeys);
            return;
        }
        throw new InvalidDataAccessApiUsageException("All keys must map to same slot for pfmerge in cluster mode");
    }
}

