/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.lang.Nullable;

public interface BoundGeoOperations<K, M>
extends BoundKeyOperations<K> {
    @Nullable
    public Long add(Point var1, M var2);

    @Nullable
    public Long add(RedisGeoCommands.GeoLocation<M> var1);

    @Nullable
    public Long add(Map<M, Point> var1);

    @Nullable
    public Long add(Iterable<RedisGeoCommands.GeoLocation<M>> var1);

    @Nullable
    public Distance distance(M var1, M var2);

    @Nullable
    public Distance distance(M var1, M var2, Metric var3);

    @Nullable
    public List<String> hash(M ... var1);

    @Nullable
    public List<Point> position(M ... var1);

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(Circle var1);

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(Circle var1, RedisGeoCommands.GeoRadiusCommandArgs var2);

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(M var1, double var2);

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(M var1, Distance var2);

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(M var1, Distance var2, RedisGeoCommands.GeoRadiusCommandArgs var3);

    @Nullable
    public Long remove(M ... var1);

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(Circle within) {
        return this.search(GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(GeoReference<M> reference, Distance radius) {
        return this.search(reference, radius, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(GeoReference<M> reference, Distance radius, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(reference, GeoShape.byRadius(radius), args);
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(GeoReference<M> reference, BoundingBox boundingBox) {
        return this.search(reference, boundingBox, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(GeoReference<M> reference, BoundingBox boundingBox, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(reference, GeoShape.byBox(boundingBox), args);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> search(GeoReference<M> var1, GeoShape var2, RedisGeoCommands.GeoSearchCommandArgs var3);

    @Nullable
    default public Long searchAndStore(K destKey, Circle within) {
        return this.searchAndStore(destKey, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    @Nullable
    default public Long searchAndStore(K destKey, GeoReference<M> reference, Distance radius) {
        return this.searchAndStore(destKey, reference, radius, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    @Nullable
    default public Long searchAndStore(K destKey, GeoReference<M> reference, Distance radius, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(destKey, reference, GeoShape.byRadius(radius), args);
    }

    @Nullable
    default public Long searchAndStore(K destKey, GeoReference<M> reference, BoundingBox boundingBox) {
        return this.searchAndStore(destKey, reference, boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    @Nullable
    default public Long searchAndStore(K destKey, GeoReference<M> reference, BoundingBox boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(destKey, reference, GeoShape.byBox(boundingBox), args);
    }

    @Nullable
    public Long searchAndStore(K var1, GeoReference<M> var2, GeoShape var3, RedisGeoCommands.GeoSearchStoreCommandArgs var4);
}

