/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Stereotype;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class CdiBean<T>
implements Bean<T>,
PassivationCapable {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final BeanManager beanManager;
    private final Set<Annotation> qualifiers;
    private final Set<Type> types;
    private final Class<T> beanClass;
    private final String passivationId;

    public CdiBean(Set<Annotation> qualifiers, Class<T> beanClass, BeanManager beanManager) {
        this(qualifiers, Collections.emptySet(), beanClass, beanManager);
    }

    public CdiBean(Set<Annotation> qualifiers, Set<Type> types, Class<T> beanClass, BeanManager beanManager) {
        Assert.notNull(qualifiers, (String)"Qualifier annotations must not be null");
        Assert.notNull((Object)beanManager, (String)"BeanManager must not be null");
        Assert.notNull(types, (String)"Types must not be null");
        Assert.notNull(beanClass, (String)"Bean class mast not be null");
        this.qualifiers = qualifiers;
        this.types = types;
        this.beanClass = beanClass;
        this.beanManager = beanManager;
        this.passivationId = this.createPassivationId(qualifiers, beanClass);
    }

    private String createPassivationId(Set<Annotation> qualifiers, Class<?> repositoryType) {
        ArrayList<String> qualifierNames = new ArrayList<String>(qualifiers.size());
        for (Annotation qualifier : qualifiers) {
            qualifierNames.add(qualifier.annotationType().getName());
        }
        Collections.sort(qualifierNames);
        StringBuilder builder = new StringBuilder(StringUtils.collectionToDelimitedString(qualifierNames, (String)":"));
        builder.append(":").append(repositoryType.getName());
        return builder.toString();
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add(this.beanClass);
        types.addAll(Arrays.asList(this.beanClass.getInterfaces()));
        types.addAll(this.types);
        return types;
    }

    protected <S> S getDependencyInstance(Bean<S> bean, Type type) {
        return (S)this.beanManager.getReference(bean, type, this.beanManager.createCreationalContext(bean));
    }

    public final void initialize() {
        this.create(this.beanManager.createCreationalContext((Contextual)this));
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Destroying bean instance %s for repository type '%s'".formatted(instance, this.beanClass.getName()));
        }
        creationalContext.release();
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getName() {
        return this.getQualifiers().contains(Default.class) ? this.beanClass.getName() : this.beanClass.getName() + "-" + this.getQualifiers().toString();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        HashSet<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : this.beanClass.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(Stereotype.class)) continue;
            stereotypes.add(annotationType);
        }
        return stereotypes;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public boolean isAlternative() {
        return this.beanClass.isAnnotationPresent(Alternative.class);
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getId() {
        return this.passivationId;
    }

    public String toString() {
        return "CdiBean: type='%s', qualifiers=%s".formatted(this.beanClass.getName(), this.qualifiers.toString());
    }
}

