/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.MappingRedisConverter;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class ObjectHashMapper
implements HashMapper<Object, byte[], byte[]> {
    private static volatile @Nullable ObjectHashMapper sharedInstance;
    private final RedisConverter converter;

    public ObjectHashMapper() {
        this(new RedisCustomConversions());
    }

    public ObjectHashMapper(RedisConverter converter) {
        Assert.notNull((Object)converter, (String)"Converter must not be null");
        this.converter = converter;
    }

    public ObjectHashMapper(@Nullable CustomConversions customConversions) {
        MappingRedisConverter mappingConverter = new MappingRedisConverter(new RedisMappingContext(), new NoOpIndexResolver(), new NoOpReferenceResolver());
        mappingConverter.setCustomConversions(customConversions == null ? new RedisCustomConversions() : customConversions);
        mappingConverter.afterPropertiesSet();
        this.converter = mappingConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectHashMapper getSharedInstance() {
        ObjectHashMapper cs = sharedInstance;
        if (cs != null) return cs;
        Class<ObjectHashMapper> clazz = ObjectHashMapper.class;
        synchronized (ObjectHashMapper.class) {
            cs = sharedInstance;
            if (cs != null) return cs;
            sharedInstance = cs = new ObjectHashMapper();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cs;
        }
    }

    @Override
    @Contract(value="null -> !null")
    public Map<byte[], byte[]> toHash(@Nullable Object source) {
        if (source == null) {
            return Collections.emptyMap();
        }
        RedisData sink = new RedisData();
        this.converter.write(source, sink);
        return sink.getBucket().rawMap();
    }

    @Override
    @Contract(value="null -> null")
    public @Nullable Object fromHash(@Nullable Map<byte[], byte[]> hash) {
        if (hash == null || hash.isEmpty()) {
            return null;
        }
        return this.converter.read(Object.class, new RedisData(hash));
    }

    public <T> @Nullable T fromHash(Map<byte[], byte[]> hash, Class<T> type) {
        return type.cast(this.fromHash(hash));
    }

    private static class NoOpIndexResolver
    implements IndexResolver {
        private static final Set<IndexedData> NO_INDEXES = Collections.emptySet();

        private NoOpIndexResolver() {
        }

        @Override
        public Set<IndexedData> resolveIndexesFor(TypeInformation<?> typeInformation, @Nullable Object value) {
            return NO_INDEXES;
        }

        @Override
        public Set<IndexedData> resolveIndexesFor(String keyspace, String path, TypeInformation<?> typeInformation, @Nullable Object value) {
            return NO_INDEXES;
        }
    }

    private static class NoOpReferenceResolver
    implements ReferenceResolver {
        private static final Map<byte[], byte[]> NO_REFERENCE = Collections.emptyMap();

        private NoOpReferenceResolver() {
        }

        @Override
        public Map<byte[], byte[]> resolveReference(Object id, String keyspace) {
            return NO_REFERENCE;
        }
    }
}

