/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.serializer.Jackson3ObjectReader;
import org.springframework.data.redis.serializer.Jackson3ObjectWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.util.Assert;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.type.TypeFactory;

public class Jackson3JsonRedisSerializer<T>
implements RedisSerializer<T> {
    private final JavaType javaType;
    private final ObjectMapper mapper;
    private final Jackson3ObjectReader reader;
    private final Jackson3ObjectWriter writer;

    public Jackson3JsonRedisSerializer(Class<T> type) {
        this((ObjectMapper)JsonMapper.shared(), type);
    }

    public Jackson3JsonRedisSerializer(JavaType javaType) {
        this((ObjectMapper)JsonMapper.shared(), javaType);
    }

    public Jackson3JsonRedisSerializer(ObjectMapper mapper, Class<T> type) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull(type, (String)"Java type must not be null");
        this.javaType = this.getJavaType(type);
        this.mapper = mapper;
        this.reader = Jackson3ObjectReader.create();
        this.writer = Jackson3ObjectWriter.create();
    }

    public Jackson3JsonRedisSerializer(ObjectMapper mapper, JavaType javaType) {
        this(mapper, javaType, Jackson3ObjectReader.create(), Jackson3ObjectWriter.create());
    }

    public Jackson3JsonRedisSerializer(ObjectMapper mapper, JavaType javaType, Jackson3ObjectReader reader, Jackson3ObjectWriter writer) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)reader, (String)"Reader must not be null");
        Assert.notNull((Object)writer, (String)"Writer must not be null");
        this.mapper = mapper;
        this.reader = reader;
        this.writer = writer;
        this.javaType = javaType;
    }

    @Override
    public byte[] serialize(@Nullable T value) throws SerializationException {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.writer.write(this.mapper, value);
        }
        catch (RuntimeException ex) {
            throw new SerializationException("Could not write JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    public @Nullable T deserialize(byte @Nullable [] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return (T)this.reader.read(this.mapper, bytes, this.javaType);
        }
        catch (RuntimeException ex) {
            throw new SerializationException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.unsafeSimpleType(clazz);
    }
}

