/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ExpireChanges;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.Expirations;
import org.springframework.util.Assert;

@NullUnmarked
class DefaultHashOperations<K, HK, HV>
extends AbstractOperations<K, Object>
implements HashOperations<K, HK, HV> {
    DefaultHashOperations(@NonNull RedisTemplate<K, ?> template) {
        super(template);
    }

    @Override
    public HV get(@NonNull K key, @NonNull Object hashKey) {
        byte[] rawHashKey;
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashValue = this.execute(arg_0 -> DefaultHashOperations.lambda$get$0(rawKey, rawHashKey = this.rawHashKey(hashKey), arg_0));
        return rawHashValue != null ? (HV)this.deserializeHashValue(rawHashValue) : null;
    }

    @Override
    public Boolean hasKey(@NonNull K key, @NonNull Object hashKey) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hExists(rawKey, rawHashKey));
    }

    @Override
    public Long increment(@NonNull K key, @NonNull HK hashKey, long delta) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hIncrBy(rawKey, rawHashKey, delta));
    }

    @Override
    public Double increment(@NonNull K key, @NonNull HK hashKey, double delta) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hIncrBy(rawKey, rawHashKey, delta));
    }

    @Override
    public @Nullable HK randomKey(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        return this.deserializeHashKey(this.execute(connection -> connection.hRandField(rawKey)));
    }

    @Override
    public Map.Entry<@NonNull HK, HV> randomEntry(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        Map.Entry rawEntry = this.execute(connection -> connection.hRandFieldWithValues(rawKey));
        return rawEntry == null ? null : Converters.entryOf(this.deserializeHashKey((byte[])rawEntry.getKey()), this.deserializeHashValue((byte[])rawEntry.getValue()));
    }

    @Override
    public List<@NonNull HK> randomKeys(@NonNull K key, long count) {
        byte[] rawKey = this.rawKey(key);
        List rawValues = this.execute(connection -> connection.hRandField(rawKey, count));
        return this.deserializeHashKeys(rawValues);
    }

    @Override
    public Map<@NonNull HK, HV> randomEntries(@NonNull K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Count must not be negative");
        byte[] rawKey = this.rawKey(key);
        List rawEntries = this.execute(connection -> connection.hRandFieldWithValues(rawKey, count));
        if (rawEntries == null) {
            return null;
        }
        LinkedHashMap<byte[], byte[]> rawMap = new LinkedHashMap<byte[], byte[]>(rawEntries.size());
        rawEntries.forEach(entry -> rawMap.put((byte[])entry.getKey(), (byte[])entry.getValue()));
        return this.deserializeHashMap(rawMap);
    }

    @Override
    public Set<@NonNull HK> keys(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.hKeys(rawKey));
        return rawValues != null ? this.deserializeHashKeys(rawValues) : Collections.emptySet();
    }

    @Override
    public Long size(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.hLen(rawKey));
    }

    @Override
    public Long lengthOfValue(@NonNull K key, @NonNull HK hashKey) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hStrLen(rawKey, rawHashKey));
    }

    @Override
    public void putAll(@NonNull K key, @NonNull Map<? extends @NonNull HK, ? extends HV> m) {
        if (m.isEmpty()) {
            return;
        }
        byte[] rawKey = this.rawKey(key);
        LinkedHashMap<byte[], byte[]> hashes = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<HK, HV> entry : m.entrySet()) {
            hashes.put(this.rawHashKey(entry.getKey()), this.rawHashValue(entry.getValue()));
        }
        this.execute(connection -> {
            connection.hMSet(rawKey, hashes);
            return null;
        });
    }

    @Override
    public List<HV> multiGet(@NonNull K key, @NonNull Collection<@NonNull HK> fields) {
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = new byte[fields.size()][];
        int counter = 0;
        for (HK hashKey : fields) {
            rawHashKeys[counter++] = this.rawHashKey(hashKey);
        }
        List rawValues = this.execute(connection -> connection.hMGet(rawKey, rawHashKeys));
        return this.deserializeHashValues(rawValues);
    }

    @Override
    public List<HV> getAndDelete(@NonNull K key, @NonNull Collection<@NonNull HK> fields) {
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = new byte[fields.size()][];
        int counter = 0;
        for (HK hashKey : fields) {
            rawHashKeys[counter++] = this.rawHashKey(hashKey);
        }
        List rawValues = this.execute(connection -> connection.hashCommands().hGetDel(rawKey, rawHashKeys));
        return this.deserializeHashValues(rawValues);
    }

    @Override
    public List<HV> getAndExpire(@NonNull K key, @Nullable Expiration expiration, @NonNull Collection<@NonNull HK> fields) {
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = new byte[fields.size()][];
        int counter = 0;
        for (HK hashKey : fields) {
            rawHashKeys[counter++] = this.rawHashKey(hashKey);
        }
        List rawValues = this.execute(connection -> connection.hashCommands().hGetEx(rawKey, expiration, rawHashKeys));
        return this.deserializeHashValues(rawValues);
    }

    @Override
    public Boolean putAndExpire(@NonNull K key, @NonNull Map<? extends @NonNull HK, ? extends HV> m,  @NonNull RedisHashCommands.HashFieldSetOption condition, @Nullable Expiration expiration) {
        if (m.isEmpty()) {
            return false;
        }
        byte[] rawKey = this.rawKey(key);
        LinkedHashMap<byte[], byte[]> hashes = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<HK, HV> entry : m.entrySet()) {
            hashes.put(this.rawHashKey(entry.getKey()), this.rawHashValue(entry.getValue()));
        }
        return this.execute(connection -> connection.hashCommands().hSetEx(rawKey, hashes, condition, expiration));
    }

    @Override
    public void put(@NonNull K key, @NonNull HK hashKey, HV value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        byte[] rawHashValue = this.rawHashValue(value);
        this.execute(connection -> {
            connection.hSet(rawKey, rawHashKey, rawHashValue);
            return null;
        });
    }

    @Override
    public Boolean putIfAbsent(@NonNull K key, @NonNull HK hashKey, HV value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        byte[] rawHashValue = this.rawHashValue(value);
        return this.execute(connection -> connection.hSetNX(rawKey, rawHashKey, rawHashValue));
    }

    @Override
    public ExpireChanges<@NonNull HK> expire(@NonNull K key, @NonNull Duration duration, @NonNull Collection<@NonNull HK> hashKeys) {
        byte[][] rawHashKeys;
        List<HK> orderedKeys = List.copyOf(hashKeys);
        byte[] rawKey = this.rawKey(key);
        List raw = this.execute(arg_0 -> DefaultHashOperations.lambda$expire$0(duration, rawKey, rawHashKeys = this.rawHashKeys(orderedKeys.toArray()), arg_0));
        return raw != null ? ExpireChanges.of(orderedKeys, raw) : null;
    }

    @Override
    public ExpireChanges<@NonNull HK> expireAt(@NonNull K key, @NonNull Instant instant, @NonNull Collection<@NonNull HK> hashKeys) {
        List<HK> orderedKeys = List.copyOf(hashKeys);
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = this.rawHashKeys(orderedKeys.toArray());
        long millis = instant.toEpochMilli();
        List raw = this.execute(connection -> TimeoutUtils.containsSplitSecond(millis) ? connection.hashCommands().hpExpireAt(rawKey, millis, rawHashKeys) : connection.hashCommands().hExpireAt(rawKey, instant.getEpochSecond(), rawHashKeys));
        return raw != null ? ExpireChanges.of(orderedKeys, raw) : null;
    }

    @Override
    public ExpireChanges<@NonNull HK> expire(@NonNull K key, @NonNull Expiration expiration, @NonNull ExpirationOptions options, @NonNull Collection<@NonNull HK> hashKeys) {
        byte[][] rawHashKeys;
        List<HK> orderedKeys = List.copyOf(hashKeys);
        byte[] rawKey = this.rawKey(key);
        List raw = this.execute(arg_0 -> DefaultHashOperations.lambda$expire$1(rawKey, expiration, options, rawHashKeys = this.rawHashKeys(orderedKeys.toArray()), arg_0));
        return raw != null ? ExpireChanges.of(orderedKeys, raw) : null;
    }

    @Override
    public ExpireChanges<@NonNull HK> persist(@NonNull K key, @NonNull Collection<@NonNull HK> hashKeys) {
        byte[][] rawHashKeys;
        List<HK> orderedKeys = List.copyOf(hashKeys);
        byte[] rawKey = this.rawKey(key);
        List raw = this.execute(arg_0 -> DefaultHashOperations.lambda$persist$0(rawKey, rawHashKeys = this.rawHashKeys(orderedKeys.toArray()), arg_0));
        return raw != null ? ExpireChanges.of(orderedKeys, raw) : null;
    }

    @Override
    public Expirations<@NonNull HK> getTimeToLive(@NonNull K key, @NonNull TimeUnit timeUnit, @NonNull Collection<@NonNull HK> hashKeys) {
        byte[][] rawHashKeys;
        if (timeUnit.compareTo(TimeUnit.MILLISECONDS) < 0) {
            throw new IllegalArgumentException("%s precision is not supported must be >= MILLISECONDS".formatted(new Object[]{timeUnit}));
        }
        List<HK> orderedKeys = List.copyOf(hashKeys);
        byte[] rawKey = this.rawKey(key);
        List raw = this.execute(arg_0 -> DefaultHashOperations.lambda$getTimeToLive$0(timeUnit, rawKey, rawHashKeys = this.rawHashKeys(orderedKeys.toArray()), arg_0));
        if (raw == null) {
            return null;
        }
        Expirations.Timeouts timeouts = new Expirations.Timeouts(TimeUnit.MILLISECONDS.equals((Object)timeUnit) ? timeUnit : TimeUnit.SECONDS, raw);
        return Expirations.of(timeUnit, orderedKeys, timeouts);
    }

    @Override
    public List<HV> values(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        List rawValues = this.execute(connection -> connection.hVals(rawKey));
        return rawValues != null ? this.deserializeHashValues(rawValues) : Collections.emptyList();
    }

    @Override
    public Long delete(@NonNull K key, Object ... hashKeys) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = this.rawHashKeys(hashKeys);
        return this.execute(connection -> connection.hDel(rawKey, rawHashKeys));
    }

    @Override
    public Map<@NonNull HK, HV> entries(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        Map entries = this.execute(connection -> connection.hGetAll(rawKey));
        return entries != null ? this.deserializeHashMap(entries) : Collections.emptyMap();
    }

    @Override
    public Cursor<Map.Entry<@NonNull HK, HV>> scan(@NonNull K key, @Nullable ScanOptions options) {
        byte[] rawKey = this.rawKey(key);
        return this.template.executeWithStickyConnection(connection -> new ConvertingCursor(connection.hScan(rawKey, options != null ? options : ScanOptions.NONE), new Converter<Map.Entry<byte[], byte[]>, Map.Entry<HK, HV>>(){

            public Map.Entry<HK, HV> convert(Map.Entry<byte[], byte[]> source) {
                return Converters.entryOf(DefaultHashOperations.this.deserializeHashKey(source.getKey()), DefaultHashOperations.this.deserializeHashValue(source.getValue()));
            }
        }));
    }

    private static /* synthetic */ List lambda$getTimeToLive$0(TimeUnit timeUnit, byte[] rawKey, byte[][] rawHashKeys, RedisConnection connection) throws DataAccessException {
        return TimeUnit.MILLISECONDS.equals((Object)timeUnit) ? connection.hashCommands().hpTtl(rawKey, rawHashKeys) : connection.hashCommands().hTtl(rawKey, timeUnit, rawHashKeys);
    }

    private static /* synthetic */ List lambda$persist$0(byte[] rawKey, byte[][] rawHashKeys, RedisConnection connection) throws DataAccessException {
        return connection.hashCommands().hPersist(rawKey, rawHashKeys);
    }

    private static /* synthetic */ List lambda$expire$1(byte[] rawKey, Expiration expiration, ExpirationOptions options, byte[][] rawHashKeys, RedisConnection connection) throws DataAccessException {
        return connection.hashCommands().applyHashFieldExpiration(rawKey, expiration, options, rawHashKeys);
    }

    private static /* synthetic */ List lambda$expire$0(Duration duration, byte[] rawKey, byte[][] rawHashKeys, RedisConnection connection) throws DataAccessException {
        return TimeoutUtils.hasMillis(duration) ? connection.hashCommands().hpExpire(rawKey, duration.toMillis(), rawHashKeys) : connection.hashCommands().hExpire(rawKey, TimeoutUtils.toSeconds(duration), rawHashKeys);
    }

    private static /* synthetic */ byte[] lambda$get$0(byte[] rawKey, byte[] rawHashKey, RedisConnection connection) throws DataAccessException {
        return connection.hGet(rawKey, rawHashKey);
    }
}

