/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Join;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class JoinVisitor
extends TypedSubtreeVisitor<Join> {
    private final RenderContext context;
    private final RenderTarget parent;
    private final StringBuilder joinClause = new StringBuilder();
    private boolean inCondition = false;
    private boolean hasSeenCondition = false;

    JoinVisitor(RenderContext context, RenderTarget parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(Join segment) {
        this.joinClause.append(segment.getType().getSql()).append(' ');
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Table && !this.inCondition) {
            this.joinClause.append(this.context.getNamingStrategy().getName((Table)segment));
            if (segment instanceof Aliased) {
                this.joinClause.append(" AS ").append(((Aliased)((Object)segment)).getAlias());
            }
        } else if (segment instanceof Condition) {
            this.inCondition = true;
            if (!this.hasSeenCondition) {
                this.hasSeenCondition = true;
                this.joinClause.append(" ON ");
                this.joinClause.append(segment);
            }
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof Condition) {
            this.inCondition = false;
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Join segment) {
        this.parent.onRendered(this.joinClause);
        return super.leaveMatched(segment);
    }
}

