/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;

public class RelationalEntityVersionUtils {
    private RelationalEntityVersionUtils() {
    }

    @Nullable
    public static <S> Number getVersionNumberFromEntity(S instance, RelationalPersistentEntity<S> persistentEntity, RelationalConverter converter) {
        if (!persistentEntity.hasVersionProperty()) {
            throw new IllegalArgumentException("The entity does not have a version property.");
        }
        ConvertingPropertyAccessor convertingPropertyAccessor = new ConvertingPropertyAccessor(persistentEntity.getPropertyAccessor(instance), converter.getConversionService());
        return (Number)convertingPropertyAccessor.getProperty(persistentEntity.getRequiredVersionProperty(), Number.class);
    }

    public static <S> S setVersionNumberOnEntity(S instance, @Nullable Number version, RelationalPersistentEntity<S> persistentEntity, RelationalConverter converter) {
        if (!persistentEntity.hasVersionProperty()) {
            throw new IllegalArgumentException("The entity does not have a version property.");
        }
        PersistentPropertyAccessor<S> propertyAccessor = converter.getPropertyAccessor(persistentEntity, instance);
        RelationalPersistentProperty versionProperty = (RelationalPersistentProperty)persistentEntity.getRequiredVersionProperty();
        propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)version);
        return (S)propertyAccessor.getBean();
    }
}

