/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.AnsiDialect;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;

public class HsqlDbDialect
extends AbstractDialect {
    public static final HsqlDbDialect INSTANCE = new HsqlDbDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return this.getOffset(offset) + " " + this.getLimit(limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };

    protected HsqlDbDialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return AnsiDialect.LOCK_CLAUSE;
    }
}

