/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.query;

import java.util.ArrayList;
import java.util.Optional;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.util.Assert;

public class RelationalExampleMapper {
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext;

    public RelationalExampleMapper(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public <T> Query getMappedExample(Example<T> example) {
        return this.getMappedExample(example, (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(example.getProbeType()));
    }

    private <T> Query getMappedExample(Example<T> example, RelationalPersistentEntity<?> entity) {
        Assert.notNull(example, (String)"Example must not be null!");
        Assert.notNull(entity, (String)"RelationalPersistentEntity must not be null!");
        PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(example.getProbe());
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(example.getMatcher());
        ArrayList criteriaBasedOnProperties = new ArrayList();
        entity.doWithProperties(property -> {
            if (matcherAccessor.isIgnoredPath(property.getName())) {
                return;
            }
            Optional optionalConvertedPropValue = (Optional)matcherAccessor.getValueTransformerForPath(property.getName()).apply(Optional.ofNullable(propertyAccessor.getProperty(property)));
            if (!optionalConvertedPropValue.isPresent()) {
                return;
            }
            Object convPropValue = optionalConvertedPropValue.get();
            boolean ignoreCase = matcherAccessor.isIgnoreCaseForPath(property.getName());
            String column = property.getName();
            switch (matcherAccessor.getStringMatcherForPath(property.getName())) {
                case DEFAULT: 
                case EXACT: {
                    criteriaBasedOnProperties.add(RelationalExampleMapper.includeNulls(example) ? Criteria.where(column).isNull().or(column).is(convPropValue).ignoreCase(ignoreCase) : Criteria.where(column).is(convPropValue).ignoreCase(ignoreCase));
                    break;
                }
                case ENDING: {
                    criteriaBasedOnProperties.add(RelationalExampleMapper.includeNulls(example) ? Criteria.where(column).isNull().or(column).like("%" + convPropValue).ignoreCase(ignoreCase) : Criteria.where(column).like("%" + convPropValue).ignoreCase(ignoreCase));
                    break;
                }
                case STARTING: {
                    criteriaBasedOnProperties.add(RelationalExampleMapper.includeNulls(example) ? Criteria.where(column).isNull().or(column).like(convPropValue + "%").ignoreCase(ignoreCase) : Criteria.where(column).like(convPropValue + "%").ignoreCase(ignoreCase));
                    break;
                }
                case CONTAINING: {
                    criteriaBasedOnProperties.add(RelationalExampleMapper.includeNulls(example) ? Criteria.where(column).isNull().or(column).like("%" + convPropValue + "%").ignoreCase(ignoreCase) : Criteria.where(column).like("%" + convPropValue + "%").ignoreCase(ignoreCase));
                    break;
                }
                default: {
                    throw new IllegalStateException(example.getMatcher().getDefaultStringMatcher() + " is not supported!");
                }
            }
        });
        Criteria criteria = Criteria.empty();
        for (Criteria propertyCriteria : criteriaBasedOnProperties) {
            if (example.getMatcher().isAllMatching()) {
                criteria = criteria.and(propertyCriteria);
                continue;
            }
            criteria = criteria.or(propertyCriteria);
        }
        return Query.query(criteria);
    }

    private static <T> boolean includeNulls(Example<T> example) {
        return example.getMatcher().getNullHandler() == ExampleMatcher.NullHandler.INCLUDE;
    }
}

