/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping.event;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.relational.core.mapping.event.AbstractRelationalEvent;
import org.springframework.data.relational.core.mapping.event.AfterConvertEvent;
import org.springframework.data.relational.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.relational.core.mapping.event.AfterLoadEvent;
import org.springframework.data.relational.core.mapping.event.AfterSaveEvent;
import org.springframework.data.relational.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.relational.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.relational.core.mapping.event.BeforeSaveEvent;

public class AbstractRelationalEventListener<E>
implements ApplicationListener<AbstractRelationalEvent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRelationalEventListener.class);
    private final Class<?> domainClass;

    public AbstractRelationalEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractRelationalEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    public void onApplicationEvent(AbstractRelationalEvent<?> event) {
        if (!this.domainClass.isAssignableFrom(event.getType())) {
            return;
        }
        if (event instanceof AfterLoadEvent) {
            this.onAfterLoad((AfterLoadEvent)event);
        } else if (event instanceof AfterConvertEvent) {
            this.onAfterConvert((AfterConvertEvent)event);
        } else if (event instanceof AfterDeleteEvent) {
            this.onAfterDelete((AfterDeleteEvent)event);
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave((AfterSaveEvent)event);
        } else if (event instanceof BeforeConvertEvent) {
            this.onBeforeConvert((BeforeConvertEvent)event);
        } else if (event instanceof BeforeDeleteEvent) {
            this.onBeforeDelete((BeforeDeleteEvent)event);
        } else if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave((BeforeSaveEvent)event);
        }
    }

    protected void onBeforeConvert(BeforeConvertEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeConvert({})", event.getEntity());
        }
    }

    protected void onBeforeSave(BeforeSaveEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeSave({})", event.getAggregateChange());
        }
    }

    protected void onAfterSave(AfterSaveEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterSave({})", event.getAggregateChange());
        }
    }

    @Deprecated
    protected void onAfterLoad(AfterLoadEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterLoad({})", event.getEntity());
        }
    }

    protected void onAfterConvert(AfterConvertEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterConvert({})", event.getEntity());
        }
    }

    protected void onAfterDelete(AfterDeleteEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterDelete({})", event.getAggregateChange());
        }
    }

    protected void onBeforeDelete(BeforeDeleteEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBeforeDelete({})", event.getAggregateChange());
        }
    }
}

