/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.util.Assert;

public class Cast
extends AbstractSegment
implements Expression {
    private final String targetType;
    private final Expression expression;

    private Cast(Expression expression, String targetType) {
        super(expression);
        Assert.notNull((Object)targetType, (String)"Cast target must not be null!");
        this.expression = expression;
        this.targetType = targetType;
    }

    public static Expression create(Expression expression, String targetType) {
        return new Cast(expression, targetType);
    }

    public String getTargetType() {
        return this.targetType;
    }

    @Override
    public String toString() {
        return "CAST(" + this.expression + " AS " + this.targetType + ")";
    }
}

