/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.util.Assert;

public class InlineQuery
extends AbstractSegment
implements TableLike {
    private final Select select;
    private final SqlIdentifier alias;

    InlineQuery(Select select, SqlIdentifier alias) {
        super(select);
        this.select = select;
        this.alias = alias;
    }

    public static InlineQuery create(Select select, SqlIdentifier alias) {
        Assert.notNull((Object)select, (String)"Select must not be null");
        Assert.notNull((Object)alias, (String)"Alias must not be null or empty");
        return new InlineQuery(select, alias);
    }

    public static InlineQuery create(Select select, String alias) {
        return InlineQuery.create(select, SqlIdentifier.unquoted(alias));
    }

    @Override
    public SqlIdentifier getName() {
        return this.alias;
    }

    @Override
    public SqlIdentifier getReferenceName() {
        return this.alias;
    }

    @Override
    public String toString() {
        return "(" + this.select + ") AS " + this.alias;
    }
}

