/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.function.Predicate;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Predicates;
import org.springframework.lang.Nullable;

public class PersistentPropertyTranslator {
    public RelationalPersistentProperty translate(RelationalPersistentProperty property) {
        return property;
    }

    public static PersistentPropertyTranslator create(@Nullable RelationalPersistentEntity<?> targetEntity) {
        return PersistentPropertyTranslator.create(targetEntity, Predicates.isTrue());
    }

    public static PersistentPropertyTranslator create(@Nullable RelationalPersistentEntity<?> targetEntity, Predicate<RelationalPersistentProperty> translationFilter) {
        return targetEntity != null ? new EntityPropertyTranslator(targetEntity, translationFilter) : new PersistentPropertyTranslator();
    }

    private static class EntityPropertyTranslator
    extends PersistentPropertyTranslator {
        private final RelationalPersistentEntity<?> targetEntity;
        private final Predicate<RelationalPersistentProperty> translationFilter;

        EntityPropertyTranslator(RelationalPersistentEntity<?> targetEntity, Predicate<RelationalPersistentProperty> translationFilter) {
            this.targetEntity = targetEntity;
            this.translationFilter = translationFilter;
        }

        @Override
        public RelationalPersistentProperty translate(RelationalPersistentProperty property) {
            if (!this.translationFilter.test(property)) {
                return property;
            }
            RelationalPersistentProperty targetProperty = (RelationalPersistentProperty)this.targetEntity.getPersistentProperty(property.getName());
            return targetProperty != null ? targetProperty : property;
        }
    }
}

