/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SqlSort
extends Sort {
    private static final Predicate<String> predicate = Pattern.compile("^[0-9a-zA-Z_\\.\\(\\)]*$").asPredicate();
    private static final long serialVersionUID = 1L;

    private SqlSort(Sort.Direction direction, List<String> paths) {
        this(Collections.emptyList(), direction, paths);
    }

    private SqlSort(List<Sort.Order> orders, @Nullable Sort.Direction direction, List<String> paths) {
        super(SqlSort.combine(orders, direction, paths));
    }

    private SqlSort(List<Sort.Order> orders) {
        super(orders);
    }

    public static SqlSort of(String ... paths) {
        return new SqlSort(DEFAULT_DIRECTION, Arrays.asList(paths));
    }

    public static SqlSort of(Sort.Direction direction, String ... paths) {
        return new SqlSort(direction, Arrays.asList(paths));
    }

    public static void validate(Sort.Order order) {
        SqlOrder ro;
        boolean isMarkedUnsafe;
        String property = order.getProperty();
        boolean bl = isMarkedUnsafe = order instanceof SqlOrder && (ro = (SqlOrder)order).isUnsafe();
        if (isMarkedUnsafe) {
            return;
        }
        if (!predicate.test(property)) {
            throw new IllegalArgumentException("order fields that are not marked as unsafe must only consist of digits, letter, '.', '_', and ''. If you want to sort by arbitrary expressions please use RelationalSort.unsafe. Note that such expressions become part of SQL statements and therefore need to be sanatized to prevent SQL injection attacks.");
        }
    }

    private static List<Sort.Order> combine(List<Sort.Order> orders, @Nullable Sort.Direction direction, List<String> paths) {
        ArrayList<Sort.Order> result = new ArrayList<Sort.Order>(orders);
        for (String path : paths) {
            result.add(new Sort.Order(direction, path));
        }
        return result;
    }

    public static SqlSort unsafe(String ... properties) {
        return SqlSort.unsafe(Sort.DEFAULT_DIRECTION, properties);
    }

    public static SqlSort unsafe(Sort.Direction direction, String ... properties) {
        Assert.notNull((Object)direction, (String)"Direction must not be null");
        Assert.notEmpty((Object[])properties, (String)"Properties must not be empty");
        Assert.noNullElements((Object[])properties, (String)"Properties must not contain null values");
        return SqlSort.unsafe(direction, Arrays.asList(properties));
    }

    public static SqlSort unsafe(Sort.Direction direction, List<String> properties) {
        Assert.notEmpty(properties, (String)"Properties must not be empty");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(properties.size());
        for (String property : properties) {
            orders.add(new SqlOrder(direction, property));
        }
        return new SqlSort(orders);
    }

    public SqlSort and(@Nullable Sort.Direction direction, String ... paths) {
        Assert.notNull((Object)paths, (String)"Paths must not be null");
        ArrayList<Sort.Order> existing = new ArrayList<Sort.Order>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            existing.add(order);
        }
        return new SqlSort(existing, direction, Arrays.asList(paths));
    }

    public SqlSort andUnsafe(@Nullable Sort.Direction direction, String ... properties) {
        Assert.notEmpty((Object[])properties, (String)"Properties must not be empty");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        String[] stringArray = this.iterator();
        while (stringArray.hasNext()) {
            Sort.Order order = (Sort.Order)stringArray.next();
            orders.add(order);
        }
        for (String property : properties) {
            orders.add(new SqlOrder(direction, property));
        }
        return new SqlSort(orders, direction, Collections.emptyList());
    }

    public static class SqlOrder
    extends Sort.Order {
        private static final long serialVersionUID = 1L;
        private final boolean unsafe;

        public static SqlOrder by(String property) {
            return new SqlOrder(Sort.DEFAULT_DIRECTION, property);
        }

        public static SqlOrder asc(String property) {
            return new SqlOrder(Sort.Direction.ASC, property, Sort.NullHandling.NATIVE);
        }

        public static SqlOrder desc(String property) {
            return new SqlOrder(Sort.Direction.DESC, property, Sort.NullHandling.NATIVE);
        }

        private SqlOrder(@Nullable Sort.Direction direction, String property) {
            this(direction, property, Sort.NullHandling.NATIVE);
        }

        private SqlOrder(@Nullable Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint) {
            this(direction, property, nullHandlingHint, false, true);
        }

        private SqlOrder(@Nullable Sort.Direction direction, String property, Sort.NullHandling nullHandling, boolean ignoreCase, boolean unsafe) {
            super(direction, property, ignoreCase, nullHandling);
            this.unsafe = unsafe;
        }

        public SqlOrder with(Sort.Direction order) {
            return new SqlOrder(order, this.getProperty(), this.getNullHandling(), this.isIgnoreCase(), this.isUnsafe());
        }

        public SqlOrder with(Sort.NullHandling nullHandling) {
            return new SqlOrder(this.getDirection(), this.getProperty(), nullHandling, this.isIgnoreCase(), this.isUnsafe());
        }

        public SqlOrder withUnsafe() {
            return new SqlOrder(this.getDirection(), this.getProperty(), this.getNullHandling(), this.isIgnoreCase(), true);
        }

        public SqlOrder ignoreCase() {
            return new SqlOrder(this.getDirection(), this.getProperty(), this.getNullHandling(), true, this.isUnsafe());
        }

        public boolean isUnsafe() {
            return this.unsafe;
        }
    }
}

