/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.query;

import java.util.List;
import java.util.function.Function;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.TypeInformation;

public class RelationalParameters
extends Parameters<RelationalParameters, RelationalParameter> {
    public RelationalParameters(ParametersSource parametersSource) {
        super(parametersSource, methodParameter -> new RelationalParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
    }

    protected RelationalParameters(ParametersSource parametersSource, Function<MethodParameter, RelationalParameter> parameterFactory) {
        super(parametersSource, parameterFactory);
    }

    protected RelationalParameters(List<RelationalParameter> parameters) {
        super(parameters);
    }

    protected RelationalParameters createFrom(List<RelationalParameter> parameters) {
        return new RelationalParameters(parameters);
    }

    public static class RelationalParameter
    extends Parameter {
        private final TypeInformation<?> typeInformation;

        protected RelationalParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
            this.typeInformation = TypeInformation.fromMethodParameter((MethodParameter)parameter);
        }

        public ResolvableType getResolvableType() {
            return this.getTypeInformation().toTypeDescriptor().getResolvableType();
        }

        public TypeInformation<?> getTypeInformation() {
            return this.typeInformation;
        }
    }
}

