/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

class BatchedActions<S extends DbAction.WithPropertyPath, B extends DbAction.BatchWithValue, C> {
    private static final Comparator<PersistentPropertyPath<RelationalPersistentProperty>> PATH_LENGTH_COMPARATOR = Comparator.comparing(PersistentPropertyPath::getLength);
    private static final Comparator<PersistentPropertyPath<RelationalPersistentProperty>> REVERSE_PATH_LENGTH_COMPARATOR = PATH_LENGTH_COMPARATOR.reversed();
    private final Map<PersistentPropertyPath<RelationalPersistentProperty>, C> actionMap = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, C>();
    private final Combiner<S, C, B> combiner;
    private final Comparator<PersistentPropertyPath<RelationalPersistentProperty>> sorting;

    static BatchedActions<DbAction.Delete, DbAction.BatchDelete, List<DbAction.Delete>> batchedDeletes() {
        return new BatchedActions<DbAction.Delete, DbAction.BatchDelete, List<DbAction.Delete>>(DeleteCombiner.INSTANCE, REVERSE_PATH_LENGTH_COMPARATOR);
    }

    static BatchedActions<DbAction.Insert, DbAction.BatchInsert, Map<IdValueSource, List<DbAction.Insert>>> batchedInserts() {
        return new BatchedActions<DbAction.Insert, DbAction.BatchInsert, Map<IdValueSource, List<DbAction.Insert>>>(InsertCombiner.INSTANCE, PATH_LENGTH_COMPARATOR);
    }

    private BatchedActions(Combiner<S, C, B> combiner, Comparator<PersistentPropertyPath<RelationalPersistentProperty>> sorting) {
        this.combiner = combiner;
        this.sorting = sorting;
    }

    void add(S action) {
        this.combiner.merge(this.actionMap, action.propertyPath(), action);
    }

    void forEach(Consumer<? super DbAction> consumer) {
        this.combiner.forEach(this.actionMap.entrySet().stream().sorted(Map.Entry.comparingByKey(this.sorting)), consumer);
    }

    static enum DeleteCombiner implements Combiner<DbAction.Delete, List<DbAction.Delete>, DbAction.BatchDelete>
    {
        INSTANCE;


        @Override
        public void merge(Map<PersistentPropertyPath<RelationalPersistentProperty>, List<DbAction.Delete>> actionMap, PersistentPropertyPath<RelationalPersistentProperty> propertyPath, DbAction.Delete action) {
            actionMap.merge(propertyPath, new ArrayList<DbAction.Delete>(Collections.singletonList(action)), (? super V actions, ? super V defaultValue) -> {
                actions.add(action);
                return actions;
            });
        }

        @Override
        public void forEach(Stream<Map.Entry<PersistentPropertyPath<RelationalPersistentProperty>, List<DbAction.Delete>>> sorted, Consumer<? super DbAction> consumer) {
            sorted.forEach(entry -> {
                List actions = (List)entry.getValue();
                if (actions.size() > 1) {
                    Collections.singletonList(new DbAction.BatchDelete(actions)).forEach(consumer);
                } else {
                    actions.forEach(consumer);
                }
            });
        }
    }

    static interface Combiner<S, C, M> {
        public void merge(Map<PersistentPropertyPath<RelationalPersistentProperty>, C> var1, PersistentPropertyPath<RelationalPersistentProperty> var2, S var3);

        public void forEach(Stream<Map.Entry<PersistentPropertyPath<RelationalPersistentProperty>, C>> var1, Consumer<? super DbAction> var2);
    }

    static enum InsertCombiner implements Combiner<DbAction.Insert, Map<IdValueSource, List<DbAction.Insert>>, DbAction.BatchInsert>
    {
        INSTANCE;


        @Override
        public void merge(Map<PersistentPropertyPath<RelationalPersistentProperty>, Map<IdValueSource, List<DbAction.Insert>>> actionMap, PersistentPropertyPath<RelationalPersistentProperty> propertyPath, DbAction.Insert action) {
            actionMap.merge(propertyPath, new HashMap<IdValueSource, ArrayList<DbAction.Insert>>(Collections.singletonMap(action.idValueSource(), new ArrayList<DbAction.Insert>(Collections.singletonList(action)))), (? super V map, ? super V mapDefaultValue) -> {
                map.merge(action.idValueSource(), new ArrayList<DbAction.Insert>(Collections.singletonList(action)), (? super V actions, ? super V listDefaultValue) -> {
                    actions.add(action);
                    return actions;
                });
                return map;
            });
        }

        @Override
        public void forEach(Stream<Map.Entry<PersistentPropertyPath<RelationalPersistentProperty>, Map<IdValueSource, List<DbAction.Insert>>>> sorted, Consumer<? super DbAction> consumer) {
            sorted.forEach(entry -> ((Map)entry.getValue()).forEach((idValueSource, inserts) -> consumer.accept(new DbAction.BatchInsert(inserts))));
        }
    }
}

