/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.rest.webmvc.ResourceProcessorInvoker;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.HeaderLinksResponseEntity;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

@Deprecated
public class ResourceProcessorHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    static final ResolvableType RESOURCE_TYPE = ResolvableType.forRawClass(Resource.class);
    static final ResolvableType RESOURCES_TYPE = ResolvableType.forRawClass(Resources.class);
    private static final ResolvableType HTTP_ENTITY_TYPE = ResolvableType.forRawClass(HttpEntity.class);
    static final Field CONTENT_FIELD = ReflectionUtils.findField(Resources.class, (String)"content");
    @NonNull
    private final HandlerMethodReturnValueHandler delegate;
    @NonNull
    private final ResourceProcessorInvoker invoker;
    private boolean rootLinksAsHeaders = false;

    public void setRootLinksAsHeaders(boolean rootLinksAsHeaders) {
        this.rootLinksAsHeaders = rootLinksAsHeaders;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Object value = returnValue;
        if (returnValue instanceof HttpEntity) {
            value = ((HttpEntity)returnValue).getBody();
        }
        if (!ResourceSupport.class.isInstance(value)) {
            this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
            return;
        }
        ResolvableType targetType = ResolvableType.forMethodReturnType((Method)returnType.getMethod());
        if (HTTP_ENTITY_TYPE.isAssignableFrom(targetType)) {
            targetType = targetType.getGeneric(new int[]{0});
        }
        ResolvableType returnValueType = ResolvableType.forClass(value.getClass());
        if (!ResourceProcessorHandlerMethodReturnValueHandler.getRawType(targetType).equals(ResourceProcessorHandlerMethodReturnValueHandler.getRawType(returnValueType))) {
            targetType = returnValueType;
        }
        ResourceSupport result = this.invoker.invokeProcessorsFor((ResourceSupport)value, targetType);
        this.delegate.handleReturnValue(this.rewrapResult(result, returnValue), returnType, mavContainer, webRequest);
    }

    Object rewrapResult(ResourceSupport newBody, Object originalValue) {
        if (!(originalValue instanceof HttpEntity)) {
            return newBody;
        }
        HttpEntity entity = null;
        if (originalValue instanceof ResponseEntity) {
            ResponseEntity source = (ResponseEntity)originalValue;
            entity = new ResponseEntity((Object)newBody, (MultiValueMap)source.getHeaders(), source.getStatusCode());
        } else {
            HttpEntity source = (HttpEntity)originalValue;
            entity = new HttpEntity((Object)newBody, (MultiValueMap)source.getHeaders());
        }
        return this.addLinksToHeaderWrapper((HttpEntity<ResourceSupport>)entity);
    }

    private HttpEntity<?> addLinksToHeaderWrapper(HttpEntity<ResourceSupport> entity) {
        return this.rootLinksAsHeaders ? HeaderLinksResponseEntity.wrap(entity) : entity;
    }

    private static Class<?> getRawType(ResolvableType type) {
        Class rawType = type.getRawClass();
        return rawType == null ? Object.class : rawType;
    }

    @ConstructorProperties(value={"delegate", "invoker"})
    public ResourceProcessorHandlerMethodReturnValueHandler(@NonNull HandlerMethodReturnValueHandler delegate, @NonNull ResourceProcessorInvoker invoker) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        if (invoker == null) {
            throw new IllegalArgumentException("invoker is null");
        }
        this.delegate = delegate;
        this.invoker = invoker;
    }

    static {
        ReflectionUtils.makeAccessible((Field)CONTENT_FIELD);
    }
}

