/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.query.Param;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.util.Supplier;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositorySearchesResource;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.ResourceStatus;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositorySearchController
extends AbstractRepositoryRestController {
    private static final String SEARCH = "/search";
    private static final String BASE_MAPPING = "/{repository}/search";
    private final RepositoryEntityLinks entityLinks;
    private final ResourceMappings mappings;
    private ResourceStatus resourceStatus;

    @Autowired
    public RepositorySearchController(PagedResourcesAssembler<Object> assembler, RepositoryEntityLinks entityLinks, ResourceMappings mappings, HttpHeadersPreparer headersPreparer) {
        super(assembler);
        Assert.notNull((Object)((Object)entityLinks), (String)"EntityLinks must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.entityLinks = entityLinks;
        this.mappings = mappings;
        this.resourceStatus = ResourceStatus.of(headersPreparer);
    }

    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.OPTIONS})
    public HttpEntity<?> optionsForSearches(RootResourceInformation resourceInformation) {
        RepositorySearchController.verifySearchesExposed(resourceInformation);
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).build();
    }

    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.HEAD})
    public HttpEntity<?> headForSearches(RootResourceInformation resourceInformation) {
        RepositorySearchController.verifySearchesExposed(resourceInformation);
        return ResponseEntity.noContent().build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search"}, method={RequestMethod.GET})
    public RepositorySearchesResource listSearches(RootResourceInformation resourceInformation) {
        RepositorySearchController.verifySearchesExposed(resourceInformation);
        Links queryMethodLinks = this.entityLinks.linksToSearchResources(resourceInformation.getDomainType());
        if (queryMethodLinks.isEmpty()) {
            throw new ResourceNotFoundException();
        }
        RepositorySearchesResource result = new RepositorySearchesResource(resourceInformation.getDomainType());
        result.add((Iterable)queryMethodLinks);
        result.add(this.getDefaultSelfLink());
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.GET})
    public ResponseEntity<?> executeSearch(RootResourceInformation resourceInformation, @RequestParam MultiValueMap<String, Object> parameters, @PathVariable String search, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler, @RequestHeader HttpHeaders headers) {
        Method method = this.checkExecutability(resourceInformation, search);
        Object result = this.executeQueryMethod(resourceInformation.getInvoker(), parameters, method, pageable, sort, assembler);
        SearchResourceMappings searchMappings = resourceInformation.getSearchMappings();
        MethodResourceMapping methodMapping = searchMappings.getExportedMethodMappingForPath(search);
        Class domainType = methodMapping.getReturnedDomainType();
        return this.toResource(result, assembler, domainType, null, headers, resourceInformation);
    }

    protected ResponseEntity<?> toResource(final Object source, final PersistentEntityResourceAssembler assembler, Class<?> domainType, Link baseLink, HttpHeaders headers, RootResourceInformation information) {
        if (source instanceof Iterable) {
            return ResponseEntity.ok(this.toResources((Iterable)source, assembler, domainType, baseLink));
        }
        if (source == null) {
            throw new ResourceNotFoundException();
        }
        if (ClassUtils.isPrimitiveOrWrapper(source.getClass())) {
            return ResponseEntity.ok((Object)source);
        }
        PersistentEntity<?, ?> entity = information.getPersistentEntity();
        if (!entity.getType().isInstance(source)) {
            return ResponseEntity.ok((Object)source);
        }
        return this.resourceStatus.getStatusAndHeaders(headers, source, entity).toResponseEntity(new Supplier<PersistentEntityResource>(){

            public PersistentEntityResource get() {
                return assembler.toFullResource(source);
            }
        });
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json"})
    public ResourceSupport executeSearchCompact(RootResourceInformation resourceInformation, @RequestHeader HttpHeaders headers, @RequestParam MultiValueMap<String, Object> parameters, @PathVariable String repository, @PathVariable String search, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) {
        Method method = this.checkExecutability(resourceInformation, search);
        Object result = this.executeQueryMethod(resourceInformation.getInvoker(), parameters, method, pageable, sort, assembler);
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        ResponseEntity<?> entity = this.toResource(result, assembler, metadata.getDomainType(), null, headers, resourceInformation);
        Object resource = entity.getBody();
        ArrayList<Link> links = new ArrayList<Link>();
        if (resource instanceof Resources && ((Resources)resource).getContent() != null) {
            for (Object obj : ((Resources)resource).getContent()) {
                if (null == obj || !(obj instanceof Resource)) continue;
                Resource res = (Resource)obj;
                links.add(this.resourceLink(resourceInformation, res));
            }
        } else if (resource instanceof Resource) {
            Resource res = (Resource)resource;
            links.add(this.resourceLink(resourceInformation, res));
        }
        return new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, links);
    }

    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<Object> optionsForSearch(RootResourceInformation information, @PathVariable String search) {
        this.checkExecutability(information, search);
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/search/{search}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Object> headForSearch(RootResourceInformation information, @PathVariable String search) {
        this.checkExecutability(information, search);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Method checkExecutability(RootResourceInformation resourceInformation, String searchName) {
        SearchResourceMappings searchMapping = RepositorySearchController.verifySearchesExposed(resourceInformation);
        Method method = searchMapping.getMappedMethod(searchName);
        if (method == null) {
            throw new ResourceNotFoundException();
        }
        return method;
    }

    private Object executeQueryMethod(RepositoryInvoker invoker, @RequestParam MultiValueMap<String, Object> parameters, Method method, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) {
        LinkedMultiValueMap result = new LinkedMultiValueMap(parameters);
        MethodParameters methodParameters = new MethodParameters(method, new AnnotationAttribute(Param.class));
        List parameterList = methodParameters.getParameters();
        List parameterTypeInformations = ClassTypeInformation.from(method.getDeclaringClass()).getParameterTypes(method);
        for (Map.Entry entry : parameters.entrySet()) {
            int parameterIndex;
            TypeInformation domainType;
            ResourceMetadata metadata;
            MethodParameter parameter = methodParameters.getParameter((String)entry.getKey());
            if (parameter == null || (metadata = this.mappings.getMetadataFor((domainType = ((TypeInformation)parameterTypeInformations.get(parameterIndex = parameterList.indexOf(parameter))).getActualType()).getType())) == null || !metadata.isExported()) continue;
            result.put((Object)parameter.getParameterName(), RepositorySearchController.prepareUris((List)entry.getValue()));
        }
        return invoker.invokeQueryMethod(method, (MultiValueMap)result, pageable.getPageable(), sort);
    }

    private static SearchResourceMappings verifySearchesExposed(RootResourceInformation resourceInformation) {
        SearchResourceMappings resourceMappings = resourceInformation.getSearchMappings();
        if (!resourceMappings.isExported()) {
            throw new ResourceNotFoundException();
        }
        return resourceMappings;
    }

    private static List<Object> prepareUris(List<Object> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(source.size());
        for (Object element : source) {
            try {
                result.add(new URI(element.toString()));
            }
            catch (URISyntaxException o_O) {
                result.add(element);
            }
        }
        return result;
    }
}

