/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.util.ObjectUtils;

class TestOperation
extends PatchOperation {
    public TestOperation(String path, Object value) {
        super("test", path, value);
    }

    @Override
    <T> void doPerform(Object target, Class<T> type) {
        Object actual;
        Object expected = TestOperation.normalizeIfNumber(this.evaluateValueFromTarget(target, type));
        if (!ObjectUtils.nullSafeEquals((Object)expected, (Object)(actual = TestOperation.normalizeIfNumber(this.getValueFromTarget(target))))) {
            throw new PatchException("Test against path '" + this.path + "' failed.");
        }
    }

    private static Object normalizeIfNumber(Object expected) {
        if (expected instanceof Double || expected instanceof Float) {
            expected = BigDecimal.valueOf(((Number)expected).doubleValue());
        } else if (expected instanceof Number) {
            expected = BigInteger.valueOf(((Number)expected).longValue());
        }
        return expected;
    }
}

