/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwarePageableArgumentResolver
implements HandlerMethodArgumentResolver,
PageableArgumentResolver {
    @NonNull
    private final JacksonMappingAwareSortTranslator translator;
    @NonNull
    private final PageableArgumentResolver delegate;

    public boolean supportsParameter(MethodParameter parameter) {
        return this.delegate.supportsParameter(parameter);
    }

    public Pageable resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Pageable pageable = this.delegate.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
        if (pageable == null || pageable.getSort() == null) {
            return pageable;
        }
        Sort translated = this.translator.translateSort(pageable.getSort(), methodParameter, webRequest);
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)translated);
    }

    public MappingAwarePageableArgumentResolver(@NonNull JacksonMappingAwareSortTranslator translator, @NonNull PageableArgumentResolver delegate) {
        if (translator == null) {
            throw new IllegalArgumentException("translator is marked @NonNull but is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is marked @NonNull but is null");
        }
        this.translator = translator;
        this.delegate = delegate;
    }
}

