/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.data.rest.webmvc.json.patch.SpelPath;

class MoveOperation
extends PatchOperation {
    private final SpelPath.UntypedSpelPath from;

    private MoveOperation(SpelPath.UntypedSpelPath path, SpelPath.UntypedSpelPath from) {
        super("move", path);
        this.from = from;
    }

    static MoveOperationBuilder from(String from) {
        return new MoveOperationBuilder(from);
    }

    @Override
    void perform(Object target, Class<?> type) {
        this.path.bindTo(type).moveFrom(this.from, target);
    }

    static class MoveOperationBuilder {
        private final String from;

        public MoveOperation to(String to) {
            return new MoveOperation(SpelPath.untyped(to), SpelPath.untyped(this.from));
        }

        private MoveOperationBuilder(String from) {
            this.from = from;
        }
    }
}

