/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

public interface RepositoryRestConfigurer {
    public static RepositoryRestConfigurer withConfig(final Consumer<RepositoryRestConfiguration> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null!");
        return new RepositoryRestConfigurer(){

            @Override
            public void configureRepositoryRestConfiguration(RepositoryRestConfiguration config, CorsRegistry cors) {
                consumer.accept(config);
            }
        };
    }

    public static RepositoryRestConfigurer withConfig(final BiConsumer<RepositoryRestConfiguration, CorsRegistry> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null!");
        return new RepositoryRestConfigurer(){

            @Override
            public void configureRepositoryRestConfiguration(RepositoryRestConfiguration config, CorsRegistry cors) {
                consumer.accept(config, cors);
            }
        };
    }

    default public void configureRepositoryRestConfiguration(RepositoryRestConfiguration config, CorsRegistry cors) {
    }

    default public void configureConversionService(ConfigurableConversionService conversionService) {
    }

    default public void configureValidatingRepositoryEventListener(ValidatingRepositoryEventListener validatingListener) {
    }

    default public void configureExceptionHandlerExceptionResolver(ExceptionHandlerExceptionResolver exceptionResolver) {
    }

    default public void configureHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
    }

    default public void configureJacksonObjectMapper(ObjectMapper objectMapper) {
    }
}

