/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.rest.webmvc.json.MappedProperties;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.util.InputStreamHttpInputMessage;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DomainObjectReader {
    private final PersistentEntities entities;
    private final Associations associationLinks;

    public DomainObjectReader(PersistentEntities entities, Associations associationLinks) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)associationLinks, (String)"Associations must not be null!");
        this.entities = entities;
        this.associationLinks = associationLinks;
    }

    public <T> T read(InputStream source, T target, ObjectMapper mapper) {
        Assert.notNull(target, (String)"Target object must not be null!");
        Assert.notNull((Object)source, (String)"InputStream must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        try {
            return this.doMerge((ObjectNode)mapper.readTree(source), target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O, (HttpInputMessage)InputStreamHttpInputMessage.of(source));
        }
    }

    public <T> T readPut(ObjectNode source, T target, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)source, (String)"ObjectNode must not be null!");
        Assert.notNull(target, (String)"Existing object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Object intermediate = mapper.readerFor(target.getClass()).readValue((JsonNode)source);
        return (T)this.mergeForPut(intermediate, target, mapper);
    }

    <T> T mergeForPut(T source, T target, ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        if (target == null || source == null) {
            return source;
        }
        Class<?> type = target.getClass();
        return (T)this.entities.getPersistentEntity(type).filter(it -> !it.isImmutable()).map(it -> {
            MergingPropertyHandler propertyHandler = new MergingPropertyHandler(source, target, (PersistentEntity<?, ?>)it, mapper);
            it.doWithProperties((SimplePropertyHandler)propertyHandler);
            it.doWithAssociations((SimpleAssociationHandler)new LinkedAssociationSkippingAssociationHandler(this.associationLinks, propertyHandler));
            DomainObjectReader.copyRemainingProperties(propertyHandler.getProperties(), source, target);
            return target;
        }).orElse(source);
    }

    private static void copyRemainingProperties(MappedProperties properties, Object source, Object target) {
        ConfigurablePropertyAccessor sourceFieldAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)source);
        BeanWrapper sourcePropertyAccessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)source);
        ConfigurablePropertyAccessor targetFieldAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)target);
        BeanWrapper targetPropertyAccessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)target);
        for (String property : properties.getSpringDataUnmappedProperties()) {
            if (targetFieldAccessor.isWritableProperty(property)) {
                targetFieldAccessor.setPropertyValue(property, sourceFieldAccessor.getPropertyValue(property));
                continue;
            }
            if (!targetPropertyAccessor.isWritableProperty(property) || !sourcePropertyAccessor.isReadableProperty(property)) continue;
            targetPropertyAccessor.setPropertyValue(property, sourcePropertyAccessor.getPropertyValue(property));
        }
    }

    <T> T merge(ObjectNode source, T target, ObjectMapper mapper) {
        try {
            return this.doMerge(source, target, mapper);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)o_O);
        }
    }

    <T> T doMerge(ObjectNode root, T target, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)root, (String)"Root ObjectNode must not be null!");
        Assert.notNull(target, (String)"Target object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Optional candidate = this.entities.getPersistentEntity(target.getClass());
        if (!candidate.isPresent()) {
            return (T)mapper.readerForUpdating(target).readValue((JsonNode)root);
        }
        PersistentEntity entity = (PersistentEntity)candidate.get();
        MappedProperties mappedProperties = MappedProperties.forDeserialization(entity, mapper);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(target);
        Iterator i = root.fields();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            JsonNode child = (JsonNode)entry.getValue();
            String fieldName = (String)entry.getKey();
            if (!mappedProperties.isWritableProperty(fieldName)) {
                i.remove();
                continue;
            }
            PersistentProperty<?> property = mappedProperties.getPersistentProperty(fieldName);
            Optional<Object> rawValue = Optional.ofNullable(accessor.getProperty(property));
            if (!rawValue.isPresent() || this.associationLinks.isLinkableAssociation(property)) continue;
            rawValue.ifPresent(it -> {
                if (child.isArray()) {
                    if (this.handleArray(child, it, mapper, property.getTypeInformation())) {
                        i.remove();
                    }
                    return;
                }
                if (child.isObject()) {
                    ObjectNode objectNode = (ObjectNode)child;
                    if (property.isMap()) {
                        if (!objectNode.fieldNames().hasNext()) {
                            return;
                        }
                        DomainObjectReader.execute(() -> this.doMergeNestedMap((Map)it, objectNode, mapper, property.getTypeInformation()));
                        if (!objectNode.fieldNames().hasNext()) {
                            i.remove();
                        }
                        return;
                    }
                    if (property.isEntity()) {
                        i.remove();
                        DomainObjectReader.execute(() -> this.doMerge(objectNode, it, mapper));
                    }
                }
            });
        }
        return (T)mapper.readerForUpdating(target).readValue((JsonNode)root);
    }

    private boolean handleArray(JsonNode node, Object source, ObjectMapper mapper, TypeInformation<?> collectionType) {
        Collection<Object> collection = DomainObjectReader.ifCollection(source);
        if (collection == null) {
            return false;
        }
        return DomainObjectReader.execute(() -> this.handleArrayNode((ArrayNode)node, collection, mapper, collectionType.getComponentType()));
    }

    private boolean handleArrayNode(ArrayNode array, Collection<Object> collection, ObjectMapper mapper, TypeInformation<?> componentType) throws Exception {
        Assert.notNull((Object)array, (String)"ArrayNode must not be null!");
        Assert.notNull(collection, (String)"Source collection must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Iterator<Object> value = new ArrayList<Object>(collection).iterator();
        boolean nestedObjectFound = false;
        for (JsonNode jsonNode : array) {
            if (!value.hasNext()) {
                collection.add(mapper.treeToValue((TreeNode)jsonNode, DomainObjectReader.getTypeToMap(null, componentType).getType()));
                continue;
            }
            Object next = value.next();
            if (ArrayNode.class.isInstance(jsonNode)) {
                return this.handleArray(jsonNode, next, mapper, DomainObjectReader.getTypeToMap(value, componentType));
            }
            if (!ObjectNode.class.isInstance(jsonNode)) continue;
            nestedObjectFound = true;
            this.doMerge((ObjectNode)jsonNode, next, mapper);
        }
        while (value.hasNext()) {
            collection.remove(value.next());
        }
        return nestedObjectFound;
    }

    private void doMergeNestedMap(Map<Object, Object> source, ObjectNode node, ObjectMapper mapper, TypeInformation<?> type) throws Exception {
        if (source == null) {
            return;
        }
        Iterator fields = node.fields();
        Class<?> keyType = DomainObjectReader.typeOrObject(type.getComponentType());
        TypeInformation valueType = type.getMapValueType();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            JsonNode value = (JsonNode)entry.getValue();
            String key = (String)entry.getKey();
            Object mappedKey = mapper.readValue(DomainObjectReader.quote(key), keyType);
            Object sourceValue = source.get(mappedKey);
            TypeInformation<?> typeToMap = DomainObjectReader.getTypeToMap(sourceValue, valueType);
            if (value instanceof ObjectNode && sourceValue != null) {
                this.doMerge((ObjectNode)value, sourceValue, mapper);
            } else if (value instanceof ArrayNode && sourceValue != null) {
                this.handleArray(value, sourceValue, mapper, DomainObjectReader.getTypeToMap(sourceValue, typeToMap));
            } else {
                source.put(mappedKey, mapper.treeToValue((TreeNode)value, typeToMap.getType()));
            }
            fields.remove();
        }
    }

    private Optional<Map<Object, Object>> mergeMaps(PersistentProperty<?> property, Optional<Object> source, Optional<Object> target, ObjectMapper mapper) {
        return source.map(it -> {
            Map sourceMap = (Map)it;
            Map targetMap = target.orElse(null);
            Map result = targetMap == null ? CollectionFactory.createMap(Map.class, (int)sourceMap.size()) : CollectionFactory.createApproximateMap((Object)targetMap, (int)sourceMap.size());
            for (Map.Entry entry : sourceMap.entrySet()) {
                Object targetValue = targetMap == null ? null : (Object)targetMap.get(entry.getKey());
                result.put(entry.getKey(), this.mergeForPut(entry.getValue(), targetValue, mapper));
            }
            if (targetMap == null) {
                return result;
            }
            try {
                targetMap.clear();
                targetMap.putAll(result);
                return targetMap;
            }
            catch (UnsupportedOperationException o_O) {
                return result;
            }
        });
    }

    private Optional<Collection<Object>> mergeCollections(PersistentProperty<?> property, Optional<Object> source, Optional<Object> target, ObjectMapper mapper) {
        return source.map(it -> {
            Iterator<Object> targetIterator;
            Collection<Object> sourceCollection = DomainObjectReader.asCollection(it);
            Collection<Object> targetCollection = DomainObjectReader.asCollection(target.orElse(null));
            Collection result = targetCollection == null ? CollectionFactory.createCollection(Collection.class, (int)sourceCollection.size()) : CollectionFactory.createApproximateCollection(targetCollection, (int)sourceCollection.size());
            Iterator<Object> sourceIterator = sourceCollection.iterator();
            Iterator<Object> iterator = targetIterator = targetCollection == null ? Collections.emptyIterator() : targetCollection.iterator();
            while (sourceIterator.hasNext()) {
                Object sourceElement = sourceIterator.next();
                Object targetElement = targetIterator.hasNext() ? targetIterator.next() : null;
                result.add(this.mergeForPut(sourceElement, targetElement, mapper));
            }
            if (targetCollection == null) {
                return result;
            }
            try {
                targetCollection.clear();
                targetCollection.addAll(result);
                return targetCollection;
            }
            catch (UnsupportedOperationException o_O) {
                return result;
            }
        });
    }

    private static Collection<Object> asCollection(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source.getClass().isArray()) {
            return Arrays.asList(ObjectUtils.toObjectArray((Object)source));
        }
        return Collections.singleton(source);
    }

    private static Collection<Object> ifCollection(Object source) {
        Assert.notNull((Object)source, (String)"Source instance must not be null!");
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])source));
        }
        return null;
    }

    private static String quote(String source) {
        return source == null ? null : "\"".concat(source).concat("\"");
    }

    private static Class<?> typeOrObject(TypeInformation<?> type) {
        return type == null ? Object.class : type.getType();
    }

    private static TypeInformation<?> getTypeToMap(Object value, TypeInformation<?> type) {
        if (type == null) {
            return ClassTypeInformation.OBJECT;
        }
        if (value == null) {
            return type;
        }
        if (Enum.class.isInstance(value)) {
            return ClassTypeInformation.from(((Enum)value).getDeclaringClass());
        }
        return value.getClass().equals(type.getType()) ? type : ClassTypeInformation.from(value.getClass());
    }

    private static <T> T execute(SupplierWithException<T> block) {
        try {
            return block.execute();
        }
        catch (Exception o_O) {
            throw new RuntimeException(o_O);
        }
    }

    private static void execute(RunnableWithException block) {
        try {
            block.execute();
        }
        catch (Exception o_O) {
            throw new RuntimeException(o_O);
        }
    }

    static interface SupplierWithException<T> {
        public T execute() throws Exception;
    }

    static interface RunnableWithException {
        public void execute() throws Exception;
    }

    private class MergingPropertyHandler
    implements SimplePropertyHandler {
        private final MappedProperties properties;
        private final PersistentPropertyAccessor<?> targetAccessor;
        private final PersistentPropertyAccessor<?> sourceAccessor;
        private final ObjectMapper mapper;

        public MergingPropertyHandler(Object source, Object target, PersistentEntity<?, ?> entity, ObjectMapper mapper) {
            Assert.notNull((Object)source, (String)"Source instance must not be null!");
            Assert.notNull((Object)target, (String)"Target instance must not be null!");
            Assert.notNull(entity, (String)"PersistentEntity must not be null!");
            Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
            this.properties = MappedProperties.forDeserialization(entity, mapper);
            this.targetAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(target), (ConversionService)new DefaultConversionService());
            this.sourceAccessor = entity.getPropertyAccessor(source);
            this.mapper = mapper;
        }

        public MappedProperties getProperties() {
            return this.properties;
        }

        public void doWithPersistentProperty(PersistentProperty<?> property) {
            if (property.isIdProperty() || property.isVersionProperty() || !property.isWritable()) {
                return;
            }
            if (!this.properties.isMappedProperty(property)) {
                return;
            }
            Optional<Object> sourceValue = Optional.ofNullable(this.sourceAccessor.getProperty(property));
            if (property.isImmutable()) {
                this.targetAccessor.setProperty(property, sourceValue.orElse(null));
                return;
            }
            Optional<Object> targetValue = Optional.ofNullable(this.targetAccessor.getProperty(property));
            Optional<Object> result = Optional.empty();
            result = property.isMap() ? DomainObjectReader.this.mergeMaps(property, sourceValue, targetValue, this.mapper) : (property.isCollectionLike() ? DomainObjectReader.this.mergeCollections(property, sourceValue, targetValue, this.mapper) : (property.isEntity() ? DomainObjectReader.this.mergeForPut(sourceValue, targetValue, this.mapper) : sourceValue));
            this.targetAccessor.setProperty(property, result.orElse(null));
        }
    }

    private static final class LinkedAssociationSkippingAssociationHandler
    implements SimpleAssociationHandler {
        private final Associations associations;
        private final SimplePropertyHandler delegate;

        public LinkedAssociationSkippingAssociationHandler(Associations associations, SimplePropertyHandler delegate) {
            Assert.notNull((Object)associations, (String)"Associations must not be null!");
            Assert.notNull((Object)delegate, (String)"Delegate SimplePropertyHandler must not be null!");
            this.associations = associations;
            this.delegate = delegate;
        }

        public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
            if (this.associations.isLinkableAssociation(association)) {
                return;
            }
            this.delegate.doWithPersistentProperty(association.getInverse());
        }
    }
}

