/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ParameterMetadata;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.PagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.support.RepositoryLinkBuilder;
import org.springframework.data.util.Lazy;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.core.AbstractEntityLinks;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryEntityLinks
extends AbstractEntityLinks {
    private final Repositories repositories;
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration config;
    private final Lazy<PagingAndSortingTemplateVariables> templateVariables;
    private final PluginRegistry<BackendIdConverter, Class<?>> idConverters;

    public RepositoryEntityLinks(Repositories repositories, ResourceMappings mappings, RepositoryRestConfiguration config, PagingAndSortingTemplateVariables templateVariables, PluginRegistry<BackendIdConverter, Class<?>> idConverters) {
        this(repositories, mappings, config, (Lazy<PagingAndSortingTemplateVariables>)Lazy.of((Object)templateVariables), idConverters);
    }

    public RepositoryEntityLinks(Repositories repositories, ResourceMappings mappings, RepositoryRestConfiguration config, Lazy<PagingAndSortingTemplateVariables> templateVariables, PluginRegistry<BackendIdConverter, Class<?>> idConverters) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull(templateVariables, (String)"PagingAndSortingTemplateVariables must not be null!");
        Assert.notNull(idConverters, (String)"BackendIdConverters must not be null!");
        this.repositories = repositories;
        this.mappings = mappings;
        this.config = config;
        this.templateVariables = templateVariables;
        this.idConverters = idConverters;
    }

    public boolean supports(Class<?> delimiter) {
        return this.repositories.hasRepositoryFor(delimiter);
    }

    public LinkBuilder linkFor(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        return new RepositoryLinkBuilder(metadata, new BaseUri(this.config.getBasePath()));
    }

    public LinkBuilder linkFor(Class<?> type, Object ... parameters) {
        return this.linkFor(type);
    }

    public Link linkToPagedResource(Class<?> type, Pageable pageable) {
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        String href = this.linkFor(type).toString();
        UriComponents components = this.prepareUri(href, (ResourceMapping)metadata, pageable);
        TemplateVariables variables = this.getTemplateVariables(components, (ResourceMapping)metadata, pageable).concat(this.getProjectionVariable(type));
        return Link.of((UriTemplate)UriTemplate.of((String)href).with(variables), (LinkRelation)metadata.getRel());
    }

    public Link linkToCollectionResource(Class<?> type) {
        return this.linkToPagedResource(type, null);
    }

    public Link linkToItemResource(Class<?> type, Object id) {
        Assert.isInstanceOf(Serializable.class, (Object)id, (String)"Id must be assignable to Serializable!");
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        Link link = this.linkForItemResource(type, id).withRel(metadata.getItemResourceRel());
        return Link.of((String)UriTemplate.of((String)link.getHref()).with(this.getProjectionVariable(type)).toString(), (LinkRelation)metadata.getItemResourceRel());
    }

    public LinkBuilder linkForItemResource(Class<?> type, Object id) {
        Assert.isInstanceOf(Serializable.class, (Object)id, (String)"Id must be assignable to Serializable!");
        String mappedId = ((BackendIdConverter)this.idConverters.getPluginFor(type).orElse(BackendIdConverter.DefaultIdConverter.INSTANCE)).toRequestId((Serializable)id, type);
        return this.linkFor(type).slash((Object)mappedId);
    }

    public Links linksToSearchResources(Class<?> type) {
        return this.linksToSearchResources(type, null, null);
    }

    public Links linksToSearchResources(Class<?> type, Pageable pageable) {
        return this.linksToSearchResources(type, pageable, null);
    }

    public Links linksToSearchResources(Class<?> type, Sort sort) {
        return this.linksToSearchResources(type, null, sort);
    }

    public Link linkToSearchResource(Class<?> domainType, LinkRelation relation) {
        return this.getSearchResourceLinkFor(domainType, relation, null, null);
    }

    public Link linkToSearchResource(Class<?> domainType, LinkRelation relation, Pageable pageable) {
        return this.getSearchResourceLinkFor(domainType, relation, pageable, null);
    }

    public Link linkToSearchResource(Class<?> domainType, LinkRelation relation, Sort sort) {
        return this.getSearchResourceLinkFor(domainType, relation, null, sort);
    }

    private Links linksToSearchResources(Class<?> type, Pageable pageable, Sort sort) {
        return (Links)this.mappings.getSearchResourceMappings(type).getExportedMappings().map(ResourceMapping::getRel).map(it -> this.getSearchResourceLinkFor(type, (LinkRelation)it, pageable, sort)).collect(Links.collector());
    }

    private Link getSearchResourceLinkFor(Class<?> type, LinkRelation rel, Pageable pageable, Sort sort) {
        Assert.notNull(type, (String)"Domain type must not be null!");
        Assert.notNull((Object)rel, (String)"Relation name must not be null!");
        SearchResourceMappings searchMappings = this.mappings.getSearchResourceMappings(type);
        MethodResourceMapping mapping = searchMappings.getExportedMethodMappingForRel(rel);
        if (mapping == null) {
            return null;
        }
        LinkBuilder builder = this.linkFor(type).slash((Object)this.mappings.getSearchResourceMappings(type).getPath()).slash((Object)mapping.getPath());
        UriComponents uriComponents = this.prepareUri(builder.toString(), mapping, pageable, sort);
        TemplateVariables variables = this.getParameterVariables(mapping).concat(this.getTemplateVariables(uriComponents, mapping, pageable, sort)).concat(this.getProjectionVariable(mapping.getReturnedDomainType()));
        return Link.of((UriTemplate)UriTemplate.of((String)uriComponents.toString()).with(variables), (LinkRelation)mapping.getRel());
    }

    private TemplateVariables getTemplateVariables(UriComponents components, ResourceMapping mapping, Pageable pageable) {
        if (mapping.isPagingResource()) {
            return ((PagingAndSortingTemplateVariables)this.templateVariables.get()).getPaginationTemplateVariables(null, components);
        }
        return TemplateVariables.NONE;
    }

    private TemplateVariables getTemplateVariables(UriComponents components, MethodResourceMapping mapping, Pageable pageable, Sort sort) {
        if (mapping.isSortableResource()) {
            return ((PagingAndSortingTemplateVariables)this.templateVariables.get()).getSortTemplateVariables(null, components);
        }
        return this.getTemplateVariables(components, (ResourceMapping)mapping, pageable);
    }

    private TemplateVariables getProjectionVariable(Class<?> type) {
        ProjectionDefinitionConfiguration projectionConfiguration = this.config.getProjectionConfiguration();
        if (projectionConfiguration.hasProjectionFor(type)) {
            return new TemplateVariables(new TemplateVariable[]{new TemplateVariable(projectionConfiguration.getParameterName(), TemplateVariable.VariableType.REQUEST_PARAM)});
        }
        return TemplateVariables.NONE;
    }

    private TemplateVariables getParameterVariables(MethodResourceMapping mapping) {
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        for (ParameterMetadata metadata : mapping.getParametersMetadata()) {
            variables.add(new TemplateVariable(metadata.getName(), TemplateVariable.VariableType.REQUEST_PARAM));
        }
        return new TemplateVariables(variables);
    }

    private UriComponents prepareUri(String uri, MethodResourceMapping mapping, Pageable pageable, Sort sort) {
        if (mapping.isSortableResource()) {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uri);
            ((PagingAndSortingTemplateVariables)this.templateVariables.get()).enhance(uriBuilder, null, sort);
            return uriBuilder.build();
        }
        return this.prepareUri(uri, (ResourceMapping)mapping, pageable);
    }

    private UriComponents prepareUri(String uri, ResourceMapping mapping, Pageable pageable) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)uri);
        if (mapping.isPagingResource()) {
            ((PagingAndSortingTemplateVariables)this.templateVariables.get()).enhance(uriBuilder, null, pageable);
        }
        return uriBuilder.build();
    }
}

