/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.Optional;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.util.Assert;

public class DefaultExcerptProjector
implements ExcerptProjector {
    private final ProjectionFactory factory;
    private final ResourceMappings mappings;

    public DefaultExcerptProjector(ProjectionFactory factory, ResourceMappings mappings) {
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null");
        this.factory = factory;
        this.mappings = mappings;
    }

    @Override
    public Object projectExcerpt(Object source) {
        Assert.notNull((Object)source, (String)"Projection source must not be null");
        ResourceMetadata metadata = this.mappings.getMetadataFor(source.getClass());
        return Optional.ofNullable(metadata).flatMap(CollectionResourceMapping::getExcerptProjection).filter(it -> !it.equals(source.getClass())).map(it -> this.factory.createProjection(it, source)).orElse(source);
    }

    @Override
    public boolean hasExcerptProjection(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        return metadata == null ? false : metadata.getExcerptProjection().isPresent();
    }
}

