/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.Collections;
import java.util.List;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.util.Assert;

public class Associations {
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration config;

    public Associations(ResourceMappings mappings, RepositoryRestConfiguration config) {
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null");
        this.mappings = mappings;
        this.config = config;
    }

    public ResourceMappings getMappings() {
        return this.mappings;
    }

    public List<Link> getLinksFor(Association<? extends PersistentProperty<?>> association, Path path) {
        Assert.notNull(association, (String)"Association must not be null");
        Assert.notNull((Object)path, (String)"Base path must not be null");
        if (this.isLinkableAssociation(association)) {
            PersistentProperty property = association.getInverse();
            ResourceMetadata metadata = this.mappings.getMetadataFor(property.getOwner().getType());
            ResourceMapping propertyMapping = metadata.getMappingFor(property);
            String href = path.slash(propertyMapping.getPath()).toString();
            UriTemplate template = UriTemplate.of((String)href).with(this.getProjectionVariable(property));
            return Collections.singletonList(Link.of((UriTemplate)template, (LinkRelation)propertyMapping.getRel()));
        }
        return Collections.emptyList();
    }

    public ResourceMetadata getMetadataFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return this.mappings.getMetadataFor(type);
    }

    public boolean isLookupType(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"Persistent property must not be null");
        return this.config.isLookupType(property.getActualType());
    }

    public boolean isIdExposed(PersistentEntity<?, ?> entity) {
        return this.config.isIdExposedFor(entity.getType());
    }

    public boolean isLinkableAssociation(Association<? extends PersistentProperty<?>> association) {
        Assert.notNull(association, (String)"Association must not be null");
        return this.isLinkableAssociation(association.getInverse());
    }

    public boolean isLinkableAssociation(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        if (!property.isAssociation() || this.config.isLookupType(property.getActualType())) {
            return false;
        }
        ResourceMetadata metadata = this.mappings.getMetadataFor(property.getOwner().getType());
        if (metadata != null && !metadata.isExported(property)) {
            return false;
        }
        metadata = this.mappings.getMetadataFor(property.getActualType());
        return metadata == null ? false : metadata.isExported();
    }

    private TemplateVariables getProjectionVariable(PersistentProperty<?> property) {
        ProjectionDefinitionConfiguration projectionConfiguration = this.config.getProjectionConfiguration();
        return projectionConfiguration.hasProjectionFor(property.getActualType()) ? new TemplateVariables(new TemplateVariable[]{new TemplateVariable(projectionConfiguration.getParameterName(), TemplateVariable.VariableType.REQUEST_PARAM)}) : TemplateVariables.NONE;
    }
}

