/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.Assert;

public class JacksonMetadata
implements Iterable<BeanPropertyDefinition> {
    private final ObjectMapper mapper;
    private final List<BeanPropertyDefinition> definitions;
    private final List<BeanPropertyDefinition> deserializationDefinitions;
    private final boolean isValue;

    public JacksonMetadata(ObjectMapper mapper, Class<?> type) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull(type, (String)"Type must not be null");
        this.mapper = mapper;
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        JavaType javaType = serializationConfig.constructType(type);
        BeanDescription description = serializationConfig.introspect(javaType);
        this.definitions = description.findProperties();
        this.isValue = description.findJsonValueAccessor() != null;
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        JavaType deserializationType = deserializationConfig.constructType(type);
        this.deserializationDefinitions = deserializationConfig.introspect(deserializationType).findProperties();
    }

    public BeanPropertyDefinition getDefinitionFor(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        return JacksonMetadata.getDefinitionFor(property, this.definitions);
    }

    public ResourceDescription getFallbackDescription(ResourceMetadata ownerMetadata, BeanPropertyDefinition definition) {
        Assert.notNull((Object)ownerMetadata, (String)"Owner's resource metadata must not be null");
        Assert.notNull((Object)definition, (String)"BeanPropertyDefinition must not be null");
        AnnotatedMember member = definition.getPrimaryMember();
        Description description = (Description)member.getAnnotation(Description.class);
        ResourceDescription fallback = TypedResourceDescription.defaultFor((LinkRelation)ownerMetadata.getItemResourceRel(), (String)definition.getInternalName(), (Class)definition.getPrimaryMember().getRawType());
        return description == null ? fallback : new AnnotationBasedResourceDescription(description, fallback);
    }

    public boolean isExported(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        return this.getDefinitionFor(property) != null;
    }

    public boolean isValueType() {
        return this.isValue;
    }

    public boolean isReadOnly(PersistentProperty<?> property) {
        BeanPropertyDefinition definition = JacksonMetadata.getDefinitionFor(property, this.deserializationDefinitions);
        return definition == null ? false : !definition.couldDeserialize();
    }

    public JsonSerializer<?> getTypeSerializer(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        try {
            SerializerProvider provider = this.mapper.getSerializerProvider();
            if (!(provider instanceof DefaultSerializerProvider)) {
                return null;
            }
            provider = ((DefaultSerializerProvider)provider).createInstance(this.mapper.getSerializationConfig(), this.mapper.getSerializerFactory());
            return provider.findValueSerializer(type);
        }
        catch (JsonMappingException o_O) {
            return null;
        }
    }

    @Override
    public Iterator<BeanPropertyDefinition> iterator() {
        return this.definitions.iterator();
    }

    private static BeanPropertyDefinition getDefinitionFor(PersistentProperty<?> property, Iterable<BeanPropertyDefinition> definitions) {
        for (BeanPropertyDefinition definition : definitions) {
            if (!definition.getInternalName().equals(property.getName())) continue;
            return definition;
        }
        return null;
    }
}

